/*****************************************************************************************************
* INTERFAZ NGSPICE
*
* Este proceso se utilizará como una interfaz para hacer que ngspcie ejecute una simulación y luego
* termine.
*/
#include <unistd.h>     /* dup2 */
#include <stdio.h>      /* printf */
#include <stdlib.h>     /* exit */
#include <sys/wait.h>   /* waitpid */
#include <string.h>     /* sprintf */

#define ENTRADA_OK                              0
#define ENTRADA_ERROR_CANTIDAD_PARAMETROS       1

#define SIMULATION_DELAY                        5   ///< Segundos de delay para simulación

int Review_input(int argc, char** argv, char **netlist_file);

int main(int argc, char *argv[]){
    pid_t   pid;
    int     pipe_fd[2];
    FILE *  sd;
    int     status;
    char *  netlist_file;
    char    comando_ngspice[100];

    if( Review_input(argc, argv, &netlist_file) == ENTRADA_OK ) {
        // Se inicialia el pipe
        if( pipe(pipe_fd) < 0 ) {
            printf("Error: No se logró crear el pipe.\n");
            exit(1);
        }

        // Se ejecuta el fork
        if( (pid = fork()) < 0 ) {
            printf("Error: No se pudo realizar el fork.\n");
            exit(2);
        }
        
        if( pid == 0 ) {
            /* Proceso Hijo */
            dup2(pipe_fd[0], 0);                        // Se redirige terminal de lectura del pipe_fd a la entrada estándar del proceso hijo (fd: 0)
            close(pipe_fd[1]);                          // Cerrar terminal escritura pipe_fd
            execlp("ngspice", "ngspice", "-p", NULL);   // Ejecutar el ngspice
            _exit(127);
        }

        /* Proceso Padre */
        close(pipe_fd[0]);                              // Cerrar terminal lectura pipe_fd
        sd = fdopen(pipe_fd[1], "w");

        /* Ejecutar la simulación indicada en la entrada */
        sprintf(comando_ngspice, "source %s\n", netlist_file);
        fprintf(sd, "%s", comando_ngspice); fflush(sd);

        /* Dar unos segundos para que procese la data */
        sleep(SIMULATION_DELAY);

        /* Ejecutar el cierre correcto del ngspice */
        fprintf(sd, "exit\n"); fflush(sd);

        fclose(sd);

        /* Esperar a que el hijo termine */
        waitpid(pid, &status, 0);
    }
    else {
        printf("Error en la invocación de interfaz_ngspice.\n");
    }
    exit(0);
}

/*****************************************************************************************************
* Review_input analiza la entrada estándar del programa organizando los parámetros entregados
* al invocarlo.
*
* @param argc número de parámetros ingresados al programa
* @param argv arreglo de argumentos de la llamada
* @param netlist_file nombre del archivo con la netlist a simular
*/
int Review_input(int argc, char* argv[], char** netlist_file) {
    
    if (argc != 2) {
        return ENTRADA_ERROR_CANTIDAD_PARAMETROS;   
    }

    *netlist_file = argv[1];
    return ENTRADA_OK;
}
