import java.io.*;
import java.util.ArrayList;

import Circuitos.GeneticController;

public class Main {

	public static void main(String[] args) throws IOException {
		System.out.println("Proceso Iniciado");

		int tamPoblacion = 100;
		int precionSelectiva = 5;

		int genMax = 10;
		int elite = 2;
		double probMutar = 0.001;
		int tamIntermedia = tamPoblacion - elite + 1;

		String filtro = "butter 1000 20";

		GeneticController ControladorCircuitos = new GeneticController(genMax, tamPoblacion, probMutar);
		ArrayList<Double[]> intermedia;
		int k = -1;
		while(k < 100) {
			k++;
			ControladorCircuitos.corregirPoblacion();
			ControladorCircuitos.calcularFitness(k, filtro);
			ControladorCircuitos.ordenarFitness();
			System.out.printf("Generacion %d, indice %d:\t%f\n",k,ControladorCircuitos.getIndex(0),ControladorCircuitos.getFitness(0));
			intermedia = ControladorCircuitos.torneo(tamIntermedia, precionSelectiva);
			intermedia = ControladorCircuitos.reproduccionUniforme(intermedia);
			ControladorCircuitos.actualizarPoblacion(elite, intermedia);
		};
		k++;
		ControladorCircuitos.corregirPoblacion();
		ControladorCircuitos.calcularFitness(k, filtro);
		ControladorCircuitos.ordenarFitness();
		System.out.printf("Generacion %d, indice %d:\t%f\n",k,ControladorCircuitos.getIndex(0),ControladorCircuitos.getFitness(0));
		System.out.println("Proceso Finalizado");
	}

}
