package Circuitos;
import java.io.*;
import java.net.*;
import java.util.*;

public class GeneticController {

    // Atributos de la clase
    private static Integer[] serie = new Integer[]{10, 12, 15, 18, 22, 27, 33, 39, 47, 56, 68, 82};
    private static int numGen = 4;
    private static int numComponentes = 3;

    private static double cPiso  = 0.1e-9;
    private static double cTecho = 100e-6;
    private static double lPiso  = 0.1e-6;
    private static double lTecho = 0.1;
    private static double rPiso  = 100;
    private static double rTecho = 10e4;

    private static String ip = "127.0.0.1";
    private static int port = 1501;
    Socket client;
    PrintWriter out;

    // Atributos
    private ArrayList<Double[]> poblacion;      // Conjunto de individuos
    private ArrayList<Double[]> evaluacion;     // Fitness y indice del individuo en la población
    private int callFitness;                    // Veces en que se llamo a la función de fitness
    private int numCromosoma;                   // Valor maximo de los genes
    private int tamPoblacion;                   // Tamaño de la población
    private double probMutar;                   // Probabilidad de mutar


    // Constructores
    public GeneticController(int numCromosoma, int tamPoblacion, double probMutar) throws IOException  {

        this.numCromosoma = numCromosoma;
        this.tamPoblacion = tamPoblacion;
        this.probMutar = probMutar;

        Double[] individuo;
		Random r = new Random();
		this.poblacion = new ArrayList<Double[]>();
		for(int i = 0; i < tamPoblacion; i++) {
			individuo = new Double[numCromosoma*numGen];
			for(int j = 0; j < individuo.length; j++) {
                switch(j%numGen) {
                    case 0:     individuo[j] = (double) r.nextInt(numComponentes + 1);
                                break;
                    case 1:     individuo[j] = (double) r.nextInt((numCromosoma - 1) + 3);
                                break;
                    case 2:     individuo[j] = (double) r.nextInt((numCromosoma - 1) + 3);
                                break;
                    case 3:     individuo[j] = r.nextDouble();
                                break;
                    default:    individuo[j] = 0.0;
                                break;
                }
            }
            poblacion.add(individuo);
        }
    }




    // Metodos que imprimen por pantalla

	/*
	 * Imprime la poblacion
	 */
	public void printPoblacion() {
		for(int i = 0; i < tamPoblacion; i++) {
			System.out.println("Individuo " + (i+1));
			for(Double num: poblacion.get(i)) {
				System.out.print(num + "-");
			}
			System.out.println("\n");
		}
	}

    /*
	 * Imprime los fitness de los individuos de la poblacion
	 */
	public void printFitness() {
		for(int i = 0; i < tamPoblacion; i++) {
			System.out.printf("Individuo %.0f:\t%.5f\n",evaluacion.get(i)[1],evaluacion.get(i)[0]);
		}
	}



    // Métodos get

    /*
     * Retorna el fitness indicado por index
     */
     public double getFitness(int index) {
		if( (index >= 0) && (index < evaluacion.size()) ) {
			return evaluacion.get(index)[0];
        }
		return -1.0;
    }

    /*
     * Retorna el fitness indicado por index
     */
     public int getIndex(int index) {
		if( (index >= 0) && (index < evaluacion.size()) ) {
			return ((int) Math.round(evaluacion.get(index)[1]));
        }
		return -1;
    }

    /*
     * Retorna el individuo indicado por el index
     */
	public Double[] getIndv(int index) {
		if( (index >= 0) && (index < tamPoblacion) ) {
			return poblacion.get(index);
		}
		return null;
	}

    /*
	 * Retorna el mejor individuo pero solo si el ArrayList
	 * evaluacion esta ordenado
	 */
	public Double[] getBestIndv() {
		return poblacion.get((int) Math.round(evaluacion.get(0)[1]));
	}




    // Métodos set

    /*
     * Sete el individuo indicado por el index
     */
	public void setIndv(int index, Double[] indv) {
		if( (index >= 0) && (index < tamPoblacion) ) {
			poblacion.set(index, indv);
		}
	}



    // Métodos para obtener el fenotipo

    /*
	 * Traduce el genotipo en fenotipo
	 */
    public String decode(int index){

        String circuito = new String("Vsource in 0 dc 0 ac 1\n");
        circuito += "Rsource 1 in 1k\n";
        circuito += "Rload 2 0 1k\n";

        if( (index >= 0) && (index < tamPoblacion) ) {
            Double[] indv = this.getIndv(index);

            int r = 1;
            int c = 1;
            int l = 1;
            int com = 0;

            for(int j = 0; j < indv.length; j++) {
                if((j%numGen) == 0) {
                    if(indv[j] == 1) {
                        circuito += ("R" + r);
                        com = 1;
                        r++;
                    } else if(indv[j] == 2) {
                        circuito += ("C" + c);
                        com = 2;
                        c++;
                    } else if(indv[j] == 3) {
                        circuito += ("L" + l);
                        com = 3;
                        l++;
                    } else {
                        com = 0;
                    }
                } else if(((j%numGen) == 3) && (com != 0)) {
                    circuito += " ";
                    if(com == 1) {
                        circuito += componenteNormalizara(indv[j],this.rPiso,this.rTecho);
                    } else if(com == 2) {
                        circuito += componenteNormalizara(indv[j],this.cPiso,this.cTecho);
                    } else {
                        circuito += componenteNormalizara(indv[j],this.lPiso,this.lTecho);
                    }
                    circuito += "\n";
                } else {
                    if(com != 0){
                        circuito += " ";
                        circuito += (int) Math.round(indv[j]);
                    }
                }
            }

        }

        return circuito;
 	}

    /*
     * Función que retorna un valor normalizado
     */
    public Double componenteNormalizara(double raw, double piso, double techo) {
        double value = (((techo - piso)*raw) + piso);
        int orden = 0;
        double diff = 100000.0;
        double aux;
        int indice = 0;

        while( !((value >= 3) && (value <= 100)) ){
            if(value > 100){
                orden++;
                value = value/10.0;
            } else {
                orden--;
                value = value*10.0;
            }
        }

        for(int j = 0; j < serie.length; j++) {
            aux = Math.abs(value - ((double) serie[j]));
            if(aux < diff){
                diff = aux;
                indice = j;
            }
        }

        return (((double) serie[indice]) * Math.pow(10, orden));
    }



    // Métodos para actualizar la población

    /*
     * Repara el individuo
     */
    public void repararIndv(int index){
        if( (index >= 0) && (index < tamPoblacion) ) {
            Double[] indv = this.getIndv(index);

            // Aqui las componentes que estan en un mismo nodo se vuelven cero
            for(int j = 0; j < indv.length; j += 4) {
                if((int) Math.round(indv[j+1]) == (int) Math.round(indv[j+2])){
                    indv[j] = 0.0;
                }
            }

            // Aqui se revisa que todos los nodos esten conectados entre si
            // Si existen nodos solitarios que no sean 1 ni 2
            // Se coneca un nodo existente al azar ya existente
            // Incluyeno 0, 1 y 2
            ArrayList<Integer> allNodes = new ArrayList<Integer>();
            ArrayList<Integer> NodesSi = new ArrayList<Integer>();
            ArrayList<Integer> NodesNo = new ArrayList<Integer>();
            for(int j = 0; j < indv.length; j += 4) {
                if((int) Math.round(indv[j]) != 0){
                    allNodes.add((int) Math.round(indv[j+1]));
                    allNodes.add((int) Math.round(indv[j+2]));
                }
            }
            int aux = 0;
            int randomIndex;
            Random rand = new Random();
            NodesSi.add(0);
            NodesSi.add(1);
            NodesSi.add(2);
            for(int j = 0; j < allNodes.size(); j++) {
                aux = Collections.frequency(allNodes, allNodes.get(j));
                if(aux == 1){
                    if((allNodes.get(j) != 0) && (allNodes.get(j) != 1) && (allNodes.get(j) != 2)){
                        NodesNo.add(allNodes.get(j));
                    }
                } else {
                    if(!(NodesSi.contains(allNodes.get(j)))) {
                        NodesSi.add(allNodes.get(j));
                    }
                }
            }
            for(int j = 0; j < indv.length; j += 4) {
                if((int) Math.round(indv[j]) != 0){
                    if( NodesNo.contains( (int) Math.round(indv[j+1]) ) ) {
                        if(NodesNo.size() > 1){
                            randomIndex = rand.nextInt(NodesNo.size());
                            while( ((int) Math.round(indv[j+1])) == NodesNo.get(randomIndex) ) {
                                randomIndex = (randomIndex + 1) % (NodesNo.size());
                            }
                            indv[j+1] = (double) NodesNo.get(randomIndex);
                            NodesNo.remove(randomIndex);
                        } else {
                            randomIndex = rand.nextInt(NodesSi.size());
                            indv[j+1] = (double) NodesSi.get(randomIndex);
                            break;
                        }
                    }
                    if( NodesNo.contains( (int) Math.round(indv[j+2]) ) ) {
                        if(NodesNo.size() > 1){
                            randomIndex = rand.nextInt(NodesNo.size());
                            if( ((int) Math.round(indv[j+2])) == NodesNo.get(randomIndex)) {
                                randomIndex = (randomIndex + 1) % (NodesNo.size());
                            }
                            indv[j+2] = (double) NodesNo.get(randomIndex);
                            NodesNo.remove(randomIndex);
                        } else {
                            randomIndex = rand.nextInt(NodesSi.size());
                            indv[j+2] = (double) NodesSi.get(randomIndex);
                            break;
                        }
                    }
                }
            }

            // Aqui las componentes que estan en un mismo nodo se vuelven cero
            for(int j = 0; j < indv.length; j += 4) {
                if((int) Math.round(indv[j+1]) == (int) Math.round(indv[j+2])){
                    indv[j] = 0.0;
                }
            }

            // Se hacen listas de coneccion para ver que todo este conectados
            // Repara si existe más de una lista
            ArrayList<ArrayList<Integer>> connections = new ArrayList<ArrayList<Integer>>();
            int first;
            int second;
            for(int j = 4; j < indv.length; j += 4) {
                if(((int) Math.round(indv[j])) == 0){
                    continue;
                }
                first = -1;
                second = -1;
                for(int i = 0; i < connections.size(); i++){
                    if(connections.get(i).contains((int) Math.round(indv[j+1]))){
                        first = i;
                    }
                    if(connections.get(i).contains((int) Math.round(indv[j+2]))){
                        second = i;
                    }
                }
                if((first < 0)&&(second < 0)){
                    connections.add(new ArrayList<Integer>());
                    connections.get(connections.size() - 1).add((int) Math.round(indv[j+1]));
                    connections.get(connections.size() - 1).add((int) Math.round(indv[j+2]));
                } else if((first >= 0)&&(second < 0)){
                    connections.get(first).add((int) Math.round(indv[j+2]));
                } else if((first < 0)&&(second >= 0)){
                    connections.get(second).add((int) Math.round(indv[j+1]));
                } else if(first == second){
                    continue;
                } else{
                    connections.get(first).addAll(connections.get(second));
                    connections.remove(second);
                }
            }
            ArrayList<Integer[]> reemplazo = new ArrayList<Integer[]>();
            int indice1 = 0;
            int indice2 = 0;
            if(connections.size() > 1){
                for(int i = 1; i < connections.size(); i++){
                    indice1 = rand.nextInt(connections.get(0).size());
                    if( connections.get(0).get(indice1) == 0 ) {
                        indice1 = (indice1 + 1) % (connections.get(0).size());
                    }
                    indice2 = rand.nextInt(connections.get(i).size());
                    if( connections.get(i).get(indice2) == 0 ) {
                        indice2 = (indice2 + 1) % (connections.get(i).size());
                    }
                    reemplazo.add(new Integer[]{connections.get(0).get(indice1), connections.get(i).get(indice2)});
                    for(int j = 0; j < connections.get(i).size(); j++) {
                        if(connections.get(i).get(indice2) != connections.get(i).get(j)){
                            connections.get(0).add(connections.get(i).get(j));
                        }
                    }
                }
            }
            for(int j = 0; j < indv.length; j += 4) {
                if((int) Math.round(indv[j]) == 0) {
                    continue;
                }
                for(int i = 0; i < reemplazo.size(); i++){
                    if(reemplazo.get(i)[0] == ((int) Math.round(indv[j+1]))){
                        indv[j+1] = (double) reemplazo.get(i)[1];
                        break;
                    }
                    if(reemplazo.get(i)[0] == ((int) Math.round(indv[j+2]))){
                        indv[j+2] = (double) reemplazo.get(i)[1];
                        break;
                    }
                }
            }

            // Se asegura que se conecte el 1 y el 2
            ArrayList<Integer> nodes = new ArrayList<Integer>();
            Integer one = 1;
            Integer two = 2;
            for(int j = 0; j < indv.length; j += 4) {
                if((int) Math.round(indv[j]) == 0) {
                    continue;
                }
                if(!(nodes.contains((int) Math.round(indv[j+1])))){
                    nodes.add( (int) Math.round(indv[j+1]) );
                }
                if(!(nodes.contains((int) Math.round(indv[j+2])))){
                    nodes.add( (int) Math.round(indv[j+2]) );;
                }
            }

            if(!(nodes.contains(one))) {
                for(Integer num: nodes) {
                    if(num != 2){
                        one = num;
                        break;
                    }
                }
                for(int j = 0; j < indv.length; j += 4) {
                    if((int) Math.round(indv[j]) == 0) {
                        continue;
                    }
                    if( ((int) Math.round(indv[j+1])) == one){
                        indv[j+1] = 1.0;
                    }
                    if( ((int) Math.round(indv[j+2])) == one){
                        indv[j+2] = 1.0;
                    }
                }
            }
            if(!(nodes.contains(two))) {
                for(Integer num: nodes) {
                    if((num != 1) && (num != one)){
                        two = num;
                        break;
                    }
                }
                for(int j = 0; j < indv.length; j += 4) {
                    if((int) Math.round(indv[j]) == 0) {
                        continue;
                    }
                    if( ((int) Math.round(indv[j+1])) == two){
                        indv[j+1] = 2.0;
                    }
                    if( ((int) Math.round(indv[j+2])) == two){
                        indv[j+2] = 2.0;
                    }
                }
            }

            // Aqui se revisa que todos los nodos esten conectados entre si
            // Si existen nodos solitarios que no sean 1 ni 2
            // Se coneca un nodo existente al azar ya existente
            // Incluyeno 0, 1 y 2
            allNodes = new ArrayList<Integer>();
            NodesSi = new ArrayList<Integer>();
            NodesNo = new ArrayList<Integer>();
            for(int j = 0; j < indv.length; j += 4) {
                if((int) Math.round(indv[j]) != 0){
                    allNodes.add((int) Math.round(indv[j+1]));
                    allNodes.add((int) Math.round(indv[j+2]));
                }
            }
            aux = 0;
            rand = new Random();
            NodesSi.add(0);
            NodesSi.add(1);
            NodesSi.add(2);
            for(int j = 0; j < allNodes.size(); j++) {
                aux = Collections.frequency(allNodes, allNodes.get(j));
                if(aux == 1){
                    if((allNodes.get(j) != 0) && (allNodes.get(j) != 1) && (allNodes.get(j) != 2)){
                        NodesNo.add(allNodes.get(j));
                    }
                } else {
                    if(!(NodesSi.contains(allNodes.get(j)))) {
                        NodesSi.add(allNodes.get(j));
                    }
                }
            }
            for(int j = 0; j < indv.length; j += 4) {
                if((int) Math.round(indv[j]) != 0){
                    if( NodesNo.contains( (int) Math.round(indv[j+1]) ) ) {
                        if(NodesNo.size() > 1){
                            randomIndex = rand.nextInt(NodesNo.size());
                            while( ((int) Math.round(indv[j+1])) == NodesNo.get(randomIndex) ) {
                                randomIndex = (randomIndex + 1) % (NodesNo.size());
                            }
                            indv[j+1] = (double) NodesNo.get(randomIndex);
                            NodesNo.remove(randomIndex);
                        } else {
                            randomIndex = rand.nextInt(NodesSi.size());
                            indv[j+1] = (double) NodesSi.get(randomIndex);
                            break;
                        }
                    }
                    if( NodesNo.contains( (int) Math.round(indv[j+2]) ) ) {
                        if(NodesNo.size() > 1){
                            randomIndex = rand.nextInt(NodesNo.size());
                            if( ((int) Math.round(indv[j+2])) == NodesNo.get(randomIndex)) {
                                randomIndex = (randomIndex + 1) % (NodesNo.size());
                            }
                            indv[j+2] = (double) NodesNo.get(randomIndex);
                            NodesNo.remove(randomIndex);
                        } else {
                            randomIndex = rand.nextInt(NodesSi.size());
                            indv[j+2] = (double) NodesSi.get(randomIndex);
                            break;
                        }
                    }
                }
            }

            this.setIndv(index, indv);
        }
    }

    /*
     * Repara población
     */
    public void corregirPoblacion(){
        for(int i = 0; i < tamPoblacion; i++){
            this.repararIndv(i);
        }
    }

    /*
	 * Solo despues de haber ordenado evaluacion
	 */
	public boolean actualizarPoblacion(int elite, ArrayList<Double[]> intermedia) {
		if(elite + intermedia.size() != poblacion.size()) {
			return false;
		}
		ArrayList<Double[]> poblacionElite = new ArrayList<Double[]>();
		for(int i = 0; i < elite; i++) {
			poblacionElite.add(poblacion.get((int) Math.round(evaluacion.get(i)[1])).clone());
		}

		for(int i = 0; i < intermedia.size(); i++) {
			poblacionElite.add(elite+i, intermedia.get(i).clone());
		}
		poblacion = poblacionElite;
		return true;
	}



    // Métodos de fitness

    /*
	 * Funcion de fitness usada para aplicar el algoritmo genetico (por ahora random)
	 */
	public double fitness(int index, int generacion, String filtro)  throws IOException {
        Double Salida = 0.0;
        String sendMsg = "G\nPepe\n" + generacion + "\n" + index + "\n"+filtro+"\n";
        sendMsg = sendMsg + this.decode(index);
        out.println(sendMsg);
        out.flush();
        // Se resive la respuesta del servidor
        try {
            String data = "";
            int ayuda;
            BufferedReader in = new BufferedReader(
                    new InputStreamReader(this.client.getInputStream()) );
            ayuda = in.read();
            while( ((char) ayuda) != '\0' ) {
                data += (char) ayuda;
                ayuda = in.read();
            }
            Salida = Double.valueOf(data);
        } catch (Exception e) {
            System.out.println(e);
            Salida = 100.0;
        }

		return Salida;
	}

    /*
	 * Calcula el fitness de toda la poblacion y los almacena en evaluacion
	 */
	public void calcularFitness(int generacion, String filtro)  throws IOException {
		evaluacion = new ArrayList<Double[]>();
		Double[] funcion;
		for(int i = 0; i < poblacion.size(); i++) {
			funcion = new Double[2];
            this.client = new Socket(
                    InetAddress.getByName(this.ip),
                    port );
            this.out = new PrintWriter(client.getOutputStream(), true);
			funcion[0] = this.fitness(i, generacion, filtro);
            this.client.close();
			funcion[1] = (double) i;
			evaluacion.add(funcion);
		}
	}

    /*
	 * Ordena evaluacion
	 */
	public void ordenarFitness() {
		Collections.sort(evaluacion, new Comparator<Double[]>() {
			public int compare(Double[] first, Double[] second) {
				return Double.compare(first[0],second[0]);
			}
		});
	}



    // Métodos de cruce

    /*
	 * Cruce uniforme. Aqui mismo se incluye la mutacion.
	 */
	public ArrayList<Double[]> reproduccionUniforme(ArrayList<Double[]> intermedia) {
		Collections.reverse(intermedia);
		ArrayList<Double[]> salida = new ArrayList<Double[]>();
		Double[] aux;
		Random r = new Random();
		int numHijos = intermedia.size();
		int index;
		while(salida.size() != (numHijos-1)) {
			aux = new Double[numCromosoma*numGen];
			index = r.nextInt(intermedia.size() - 1) + 1;
			for(int j = 0; j < numCromosoma*numGen; j++) {
				if(r.nextInt(2) == 1) {
					aux[j] = intermedia.get(0)[j];
				} else {
					aux[j] = intermedia.get(index)[j];
				}

				if(r.nextDouble() < probMutar) {
                    switch(j%numGen) {
                        case 0:     aux[j] = (double) r.nextInt(numComponentes + 1);
                                    break;
                        case 1:     aux[j] = (double) r.nextInt((numCromosoma - 1) + 3);
                                    break;
                        case 2:     aux[j] = (double) r.nextInt((numCromosoma - 1) + 3);
                                    break;
                        case 3:     aux[j] = r.nextDouble();
                                    break;
                        default:    aux[j] = 0.0;
                                    break;
                    }
				}
			}
			salida.add(aux.clone());
			intermedia.remove(0);
		}
		return salida;
	}



    // Métodos de selección

    /*
	 * Seleccion por torneo, pero primero el arraylist evalucion
	 * debe estar ordenado
	 */
	public ArrayList<Double[]> torneo(int Seleccion, int precionSelectiva) {
		ArrayList<Double[]> salida = new ArrayList<Double[]>();
		ArrayList<Integer> aux = new ArrayList<Integer>();
		Integer[] coliseo = new Integer[precionSelectiva];
		Random r = new Random();
		int minValue;
		for(int i = 0; i < Seleccion; i++) {
			minValue = Integer.MAX_VALUE;
			for(int j = 0; j < precionSelectiva; j++) {
				coliseo[j] = r.nextInt(poblacion.size());
			}
			for(Integer num: coliseo) {
				if(minValue > num) {
					minValue = num;
				}
			}
			aux.add(minValue);
		}
		Collections.sort(aux);
		for(int num: aux) {
			salida.add(poblacion.get((int) Math.round(evaluacion.get(num)[1])).clone());
		}
		salida = new ArrayList<Double[]>(salida);
		return salida;
	}



}
