import javax.swing.*;
import javax.swing.table.DefaultTableModel;

import java.awt.*;
import java.awt.event.*;
import java.time.*;
import java.util.ArrayList;
import java.net.*;
import java.io.*;
import java.util.*;

public class main {

	public static void main(String[] args) {
		// TODO Auto-generated method stub
		SwingUtilities.invokeLater(new Runnable() {   // implementación Swing recomendada
            public void run() {
               MainFrame frame = new MainFrame();
               frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
               frame.setVisible(true);
            } // run ends
         });

	}
}

/**
A frame containing the application main GUI
*/
class MainFrame extends JFrame {
	/**
	Default constructor. Sets up the window and adds the components of the main tab
	*/
	public MainFrame() {
		setTitle("Your ToDo-List");
		setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
		Container contentPane = getContentPane();
		//add Todo-List to frame
		todo = new TodoList(this);
		//add  to frame
		//create TabbedPane with Subjects and TodoList
		JPanel panel1 = new JPanel();
		tabbedPane = new JTabbedPane(JTabbedPane.TOP, JTabbedPane.SCROLL_TAB_LAYOUT);
		tabbedPane.addTab("To-Do",panel1);
		//add Buttons to create, save and update to Pane1
		JButton addSubject = new JButton("add Subject");
    JButton saveList = new JButton("save List");
    JButton updateList = new JButton("updateList");
		addSubject.addActionListener(new SubjectCreationListener(todo));
    saveList.addActionListener(new SaveListCreationListener(this));
    updateList.addActionListener(new UpdateListCreationListener(this));
		panel1.add(addSubject);
    panel1.add(saveList);
		panel1.add(updateList);
		contentPane = getContentPane();
		
		//add list of courses
		model = new DefaultTableModel(); 
		table = new JTable(model); 
		model.addColumn("Course"); 
		model.addColumn("Next evaluation: ");
		scrollPane = new JScrollPane(table);
		table.setFillsViewportHeight(true);
		
		
		contentPane.add(tabbedPane,BorderLayout.CENTER);
		panel1.add(scrollPane);

	}		
	/** To add a new tab
	@param subject The subject that the tab corresponds to
	*/
	public void addTab(Subject subject) {

		tabbedPane.addTab(subject.getName(),new SubjectPanel(subject,this));
		model.addRow(new Object[]{subject.getName()," "});
		
	}
	/** Add new evaluation to the main list
	@param s The subject that has the new evaluation
	@param e The evaluation to be added
	*/
	public void addEvaluation(Subject s,Evaluation e) {
		ArrayList<Evaluation> eval = s.getEvaluation();
		for(Evaluation eCompare : eval) {
			if ( e.getDate().isBefore(LocalDateTime.now())) return;
			if( !eCompare.getDate().isBefore(LocalDateTime.now()) && e.getDate().isAfter(eCompare.getDate())) return;
		}
		
		int index = todo.findSubject(s);
		model.setValueAt(e.getDate(), index, 1);
	}
	
	/** Too delete one subject
	@param s Subject to be deleted
	*/
	public void deleteSubject(Subject s) {
		int index = todo.findSubject(s);
		todo.deleteSubject(index);
		model.removeRow(index);
		tabbedPane.remove(index+1);
	}
	
 /** To sent todo list to remote server
 */
  public void saveList() {
		try
     {  
       //connect with remote Server
       Socket s = new Socket("aragorn.elo.utfsm.cl",  PORTNUMBER);
       ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
       ObjectInputStream in = new ObjectInputStream(s.getInputStream());
       // send status
       out.writeObject(new String("write"));
       // send ArrayList<Subject>
       out.writeObject(todo.getSubject());
     }
     catch (IOException e)
     {  
        e.printStackTrace();
     }
	}
 
  /** method to receive TodoList from remote server
  */
 	public void updateList() {
    try
    {
     // connect with remote server
     Socket s = new Socket("aragorn.elo.utfsm.cl",  PORTNUMBER);
     ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
     ObjectInputStream in = new ObjectInputStream(s.getInputStream());
     // delete old subjects
     Iterator<Subject> iter = todo.getSubject().iterator();
     while (iter.hasNext()){
       this.deleteSubject(iter.next());
       iter.remove();
     }
     // send status
     out.writeObject(new String("read"));
     // reload ArrayList subjects
     todo.reloadSubjects((ArrayList<Subject>) in.readObject());
     //System.out.println("Name of Subject" + todo.getSubject().get(0).getName());
     // add new Tab for every Subject
     Iterator<Subject> iter_sub = todo.getSubject().iterator();
     while (iter_sub.hasNext()){
       Subject subject_next = iter_sub.next();
       this.addTab(subject_next); 
       // add Evaluations to Tab
       Iterator<Evaluation> iter_eval = subject_next.getEvaluation().iterator();
       while (iter_eval.hasNext()){
         this.addEvaluation(subject_next, iter_eval.next());
         iter_eval.remove();
       }
       iter_sub.remove();
     }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
	} 
 
	/** Default width of frame
	*/
	public static final int DEFAULT_WIDTH = 600;
	/** Default height of frame
	*/
	public static final int DEFAULT_HEIGHT = 600;
	/**  Number of port to connect with remote server
  */
  private static final int PORTNUMBER = 47200;
  /** The todo-list belonging to the frame
	*/
	private TodoList todo;
	/** JTabbedPane of the window
	*/
	private JTabbedPane tabbedPane;
	/** Table at first tab
	*/
	private JTable table;
	/** Scrollpane for the list
	*/
	private JScrollPane scrollPane;
	/** Tablemodel for the table
	*/
	private DefaultTableModel model;
}

/** A class for the subject-tabs GUI
*/
class SubjectPanel extends JPanel{ 
	/** Constructor.
	@param s The subject of the tab where the GUI is placed
	@param f The frame that the GUI is placed within
	*/
	SubjectPanel(Subject s,MainFrame f){
		frame =f;
		Delete = new JButton("Delete");
		Delete.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				int reply = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete subject?", "Delete subject?",  JOptionPane.YES_NO_OPTION);
				if (reply == JOptionPane.YES_OPTION)
				{
				   System.out.println("You clicked yes");
				   frame.deleteSubject(Subject);
				}
			}
		});
		addEvaluation = new JButton("add Evaluation");
		Subject=s;
		
		
		model = new DefaultTableModel(); 
		table = new JTable(model); 
		model.addColumn("Name"); 
		model.addColumn("Date");
		list = Subject.getEvaluation();
		for(Evaluation e : list) {
			model.addRow(new Object[]{e.getName(),e.getDate()});
		}
		scrollPane = new JScrollPane(table);
		//scrollPane.setPreferredSize(new Dimension(40,40));
		table.setFillsViewportHeight(true);
		
		add(Evaluations);
		add(scrollPane);
		//add(table);
		add(addEvaluation);
		add(Delete);
		addEvaluation.addActionListener(new EvaluationCreationListener(this, list));
		
		
	}
	/** To add evaluation to subject
	*/
	void addEvaluation() {
		model.addRow(new Object[]{list.get(list.size()-1).getName(), list.get(list.size()-1).getDate()});
		frame.addEvaluation(Subject,list.get(list.size()-1));
	}
	
	/** TableModel of the table in the GUI
	*/
	private DefaultTableModel model;
	/** ArrayList containing all the evaluations of the subject
	*/
	private ArrayList<Evaluation> list;
	private JLabel Evaluations = new JLabel("Evaluations:");
	private JButton Delete, addEvaluation;
	private JTable table;
	private JScrollPane scrollPane;
	/** Subject which is placed in the tab
	*/	
	private Subject Subject;
	private MainFrame frame;
	
}

/** Class for the ActionListener of the add subject button
*/
class SubjectCreationListener implements ActionListener{
		/** Constructor. 
		@param todo The TodoList to have a subject added to it
		*/
	   public SubjectCreationListener(TodoList todo) {this.todo = todo;}
	   /** actionPerformed method
	   */	   
	   	public void actionPerformed(ActionEvent event){
	   		System.out.println("You clicked add Subject");
	   		SubjectConfiguratorFrame configurator = new SubjectConfiguratorFrame(todo);
	   		configurator.setVisible(true);
	   }
	   private TodoList todo;
	}

/** Class for the ActionListener of the add evaluation button
*/
class EvaluationCreationListener implements ActionListener{
	/** Constructor 
	@param subjectPanel The subjectPanel belonging to the subject
	@param evaluations  The ArrayList<Evaluation> belonging to the subject
	*/
	public EvaluationCreationListener(SubjectPanel subjectPanel, ArrayList<Evaluation> evaluations) {this.subjectPanel = subjectPanel; this.evaluations = evaluations;}
		/** actionPerformed method
		*/
		public void actionPerformed(ActionEvent event) {
			System.out.println("You clicked add Evaluation");
			EvaluationConfiguratorFrame configurator = new EvaluationConfiguratorFrame(subjectPanel, evaluations);
			configurator.setVisible(true);		
	}
	
	private SubjectPanel subjectPanel;	
	private ArrayList<Evaluation> evaluations;
}

/** Class for the ActionListener of the save button
*/
class SaveListCreationListener implements ActionListener{
  /**Constructor
  @param parent The parent MainFrame
  */
	public SaveListCreationListener(MainFrame parent) {this.parent = parent;}
		/** action Performed method
    */
    public void actionPerformed(ActionEvent event){
				System.out.println("You clicked save List");
		    parent.saveList();
		}
   private MainFrame parent;
}

class UpdateListCreationListener implements ActionListener{
  /** Class for the ActionListener of the save button
  */
	public UpdateListCreationListener(MainFrame parent) {this.parent = parent;}
		/** action Performed method
    */
    public void actionPerformed(ActionEvent event){
				System.out.println("You clicked update List");
				parent.updateList();
		}	
		private MainFrame parent;
}


