import java.util.ArrayList;
import javax.swing.JFrame;
import java.net.*;
import java.io.*;
import java.time.*;

/** Class to store information for the Todo-list */
class TodoList implements Serializable{
	/** Constructor.
	@param f The main frame that holds the todo-list */ 
	public TodoList(MainFrame f) {
		frame = f;
		subjects = new ArrayList<Subject>();
	}
	/** Method to add subject
	@param subject The Subject to be added */
	public void addSubject(Subject subject) {
		subjects.add(subject);
		frame.addTab(subject);
	}
	
	/** Method to find index of specific Subject in the attribute ArrayList<Subject> 
	subjects. Returns 0 if not found */
	int findSubject(Subject s) {
		for (int i = 0; i<subjects.size();i++) {
			if (subjects.get(i)==s) {
				return i;
			}
		}
		return 0;
	}
	
	/** Method to delete subject
	@param i The index in the ArrayList<Subject> subject
	*/
	public void deleteSubject(int i) {
		subjects.remove(i);
	}
 
  /** Method to return the ArrayList of the subjects
 	@return ArrayList of Subject
 	*/
 	public ArrayList<Subject> getSubject(){
 		return subjects;
 	}
  
  /** Method to reload ArrayList of the subjects 
  @param subjects ArrayList of the subjects
  */
  public void reloadSubjects(ArrayList<Subject> subjects){
    this.subjects = subjects;
  }
  
	
	/** ArrayList<Subject> that stores the Subjects of the Todo-list */
	private ArrayList<Subject> subjects;
	/** The MainFrame holding the todo-list */
	private MainFrame frame;
}