import java.awt.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;

/** Class for the frame of the add Subject-window*/
public class SubjectConfiguratorFrame extends JFrame {
	/** Constructor. 
	@param todo The TodoList which contains the Subjects in an ArrayList
	*/
	public SubjectConfiguratorFrame(TodoList todo) {
		this.todo = todo;
		setTitle("Create Subject");
		setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
		addWindowListener (new WindowAdapter (){ 
	         public void windowClosing(WindowEvent e) {
	            dispose(); //dispose window when closed
	         }
	         }
	      );

		SubjectConfiguratorGUI gui = new SubjectConfiguratorGUI(this,todo);
		getContentPane().add(gui);
		pack();
		setVisible(true);
	}
	/** Empty ActionPerformed
	@param event ActionEvent that calls the method
	*/
	public void ActionPerformed(ActionEvent event) {};
	/** The TodoList which contains the Subjects in an ArrayList*/
	private TodoList todo;
	/** Default width of the window*/
	public static final int DEFAULT_WIDTH = 350;
	/** Default heigh of the window*/
	public static final int DEFAULT_HEIGHT = 350;	
}


/** Class for the GUI of the add Subject-window*/
class SubjectConfiguratorGUI extends JPanel {
	/** Constructor. 
	@param frame The parent SubjectConfiguratorFrame of the GUI
	@param todo The Todolist which contains the Subjects in an ArrayList
	*/
	public SubjectConfiguratorGUI(JFrame frame,TodoList todo) {
		this.todo = todo;
		parent = frame;
		//set layout for the window
		//add Panel with information requests
		setLayout(new GridLayout(0,2));
		add(name_text);
		add(name);
		add(code_text);
		add(code);
		add(professor_text);
		add(professor);
		add(credits_text);
		add(credits);
		add(save);	
		//add ActionListener for save button
		save.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				if (name.getText().isEmpty()) System.out.println("You need to enter a name");
				if (code.getText().isEmpty()) System.out.println("You need to enter a code");
				if (professor.getText().isEmpty()) System.out.println("You need to enter a professor");
				if (credits.getText().isEmpty()) System.out.println("You need to enter a number of credits");
				else {
					todo.addSubject(new Subject(name.getText(),code.getText(),professor.getText(),credits.getText()));
					parent.dispose();
				}
			}
		});
	}
	private JLabel name_text = new JLabel("name:");
	private JLabel code_text = new JLabel("code");
	private JLabel professor_text = new JLabel("professor:");
	private JLabel credits_text = new JLabel("credits:");			
	private JTextField name = new JTextField(10);
	private JTextField code = new JTextField(10);
	private JTextField professor = new JTextField(10);
	private JTextField credits = new JTextField(1);
	private JButton save = new JButton("save");
	private TodoList todo;
	private JFrame parent;	
}
