import java.util.*;
import java.io.*;

/** Class for Subjects*/
public class Subject implements Serializable {
	/** Constructor
	@param name The name of the subject
	@param code The code of the subject
	@param professor The name of the professor
	@param credits Number of credits
	*/
	public Subject(String name, String code, String professor, String credits){
		this.name=name;
		this.code = code;
		this.professor = professor;
		this.credits = credits;
		eval = new ArrayList<Evaluation>();
	}
	
	/** Method to add new evaluation to the subject
	@param e The evaluation to be added
	*/
	public void addEvaluation(Evaluation e){
		eval.add(e);
	}
	
	/** Method to return the ArrayList of the subject
	@return ArrayList of Evaluation
	*/
	public ArrayList<Evaluation> getEvaluation(){
		return eval;
	}
	
	/** Method to return name of subject
	@return Name of the subject
	*/
	public String getName() {  
	return name;
	}


	/** Name of subject*/
	private String name;
	/** Code of subject */
	private String code;
	/** Name of professor */
	private String professor;
	/** Number of credits */
	private String credits;
	/** ArrayList that contains the evaluations of the subject */
	private ArrayList<Evaluation> eval;
	

}