import java.io.*;
import java.net.*;
import java.time.*;
import javax.swing.*;
import java.util.ArrayList;

/**Class for the server
*/
public class Server
{
  public static void main(String[] args){
    try
    {
      //establish server socket
      ServerSocket s = new ServerSocket(PORTNUMBER); 
      ArrayList<Subject> subjects = new ArrayList<Subject>();
      while(true){
        //wait for client connection
        Socket socket = s.accept();
        //create stream for input and output
        ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
        ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
        // read status from client
        String status = (String) in.readObject();  
        switch(status){
          case ("write"):
            subjects = (ArrayList<Subject>) in.readObject();
            System.out.println("Succesfully actualized todolist.");
            break;
          case("read"):
            out.writeObject(subjects);
            break;      
        }  
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }  
  /** static final int that stores the portnumber of the server
  */
  private static final int PORTNUMBER = 47200; 
  
}