import java.awt.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import java.time.*;

/** Class for the frame of the add evaluation-window*/
public class EvaluationConfiguratorFrame extends JFrame {
	/** Constructor. 
	@param subjectPanel The SubjectPanel of the subject with a new evaluation
	@param evaluations The ArrayList of the subject with new evaluation
	*/
	public EvaluationConfiguratorFrame(SubjectPanel subjectPanel, ArrayList<Evaluation> evaluations) {
		this.subjectPanel = subjectPanel;
		this.evaluations = evaluations;
		setTitle("Create Evaluation");
		addWindowListener (new WindowAdapter (){ //dispose window when closed 
	         public void windowClosing(WindowEvent e) {
	            dispose();
	         }
	         }
	      );

		EvaluationConfiguratorGUI gui = new EvaluationConfiguratorGUI(this, subjectPanel, evaluations);
		getContentPane().add(gui);
		pack();
		setVisible(true);
	}
	/** Empty ActionPerformed
	@param event Event that calls the mathod
	*/
	public void ActionPerformed(ActionEvent event) {};
	/** The ArrayList of the subject with new evaluation*/
	private ArrayList<Evaluation> evaluations;
	/** The SubjectPanel of the subject with a new evaluation*/
	private SubjectPanel subjectPanel; 
	/** Default width of the window*/
	public static final int DEFAULT_WIDTH = 350;
	/** Default heigh of the window*/
	public static final int DEFAULT_HEIGHT = 350;	
}

/** Class for the GUI of the add evaluation-window*/
class EvaluationConfiguratorGUI extends JPanel{
	/** Constructor. 
	@param parent The parent EvaluationConfiguratorFrame of the GUI
	@param subjectPanel The SubjectPanel of the subject with a new evaluation
	@param evaluations The ArrayList of the subject with new evaluation
	*/
	public EvaluationConfiguratorGUI(EvaluationConfiguratorFrame parent, SubjectPanel subjectPanel, ArrayList<Evaluation> evaluations) {
		this.parent = parent;
		this.evaluations = evaluations;
		this.subjectPanel = subjectPanel;
		//set layout for the window
		setLayout(new GridLayout(0,1));
		JPanel name_field = new JPanel(new FlowLayout());
		name_field.add(name_text);
		name_field.add(name);
		add(name_field);
		JPanel date_field = new JPanel(new FlowLayout());
		date_field.add(date_text);
		date_field.add(day);
		date_field.add(month);
		date_field.add(year);
		add(date_field);
		JPanel time_field = new JPanel(new FlowLayout());
		time_field.add(time_text);
		time_field.add(hour);
		time_field.add(minute);		
		add(time_field);
		add(save);
		//add ActionListener for save button
		save.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				if (name.getText().isEmpty()) System.out.println("You need to enter a name");
				if (day.getText().isEmpty()) System.out.println("You need to enter the date in right format");
				if (month.getText().isEmpty()) System.out.println("You need to enter the date in right format");
				if (year.getText().isEmpty()) System.out.println("You need to enter the date in right format");
				else {
					int yearNumber = Integer.parseInt(year.getText());
					int monthNumber = Integer.parseInt(month.getText());
					int dayNumber = Integer.parseInt(day.getText());
					int hourNumber = Integer.parseInt(hour.getText());
					int minuteNumber = Integer.parseInt(minute.getText());
					LocalDateTime date = LocalDateTime.of(yearNumber, monthNumber, dayNumber, hourNumber, minuteNumber);
					Evaluation evaluation = new Evaluation(name.getText(),date);
					evaluations.add(evaluation);
					subjectPanel.addEvaluation();
					parent.dispose();
				}
			}
		});
		
		
	}
	private JLabel name_text = new JLabel("Name:");
	private JLabel date_text = new JLabel("Date(dd/mm/yyyy):");
	private JLabel time_text = new JLabel("Time(hh/mm)");
	private JTextField name = new JTextField(10);
	private JTextField day = new JTextField(2);
	private JTextField month = new JTextField(2);
	private JTextField year = new JTextField(4);
	private JTextField hour = new JTextField(2);
	private JTextField minute = new JTextField(2);
	private JButton save = new JButton("Save");
	private EvaluationConfiguratorFrame parent;
	private ArrayList<Evaluation> evaluations;
	private SubjectPanel subjectPanel;
}