import java.time.*;
import java.io.*;

/** Class for Evaluations*/
public class Evaluation implements Serializable{
	/** Constructor
	@param s The name of the evaluation
	@param d The LocalDateTime of the evaluation
	*/
	public Evaluation(String s, LocalDateTime d){
		name = s;
		date = d;
	}
	
	/** Returns name of evaluation
	@return The name of the class
	*/
	public String getName(){
		return name;
	}
	
	/** Returns the date and time of the evaluation as a LocalDateTime object
	@return The date and time as LocalDateTime object
	*/
	public LocalDateTime getDate(){
		return date;
	}
 
	
	/** The name of the evaluation*/
	private String name;
	/** The date and time of the evaluation stored as LocalDateTime*/
	private LocalDateTime date;
}