#! /bin/bash
if [ "$#" -ne 2 ]; then					# Comprueba que se haya ingresado la cantidad de parametros necesaria
  echo "USO: $0 <SEGUNDOS> <DIRECTORIO>"
  exit
fi
if [ "$1" -le 0 ]; then					# Comprueba que el primer parametro sea mayor que cero
  echo "El tiempo en segundos debe ser mayor a 0."
  exit
fi
if [ ! -d "$2" ]; then					# Comprueba que el directorio sea valido
  echo "El directorio $2 no existe."
  exit
fi
echo -n "Ingrese el servidor smtp a  utilizar: "
read server
echo -n "Ingrese el puerto donde este escucha: "
read port
echo -n "Ingrese la cuenta email desde donde se enviara la alerta: "
read src
while [ `echo $src | tr -dc '@' | wc -c` -ne 1 ]; do	# Hace una revision que haya un @ para que el mail sea valido
  echo -n "Cuenta email invalida. Por favor ingrese una cuenta valida: "
  read src
done
echo -n "Ingrese la password en formato codificado base64: "
read pass64
echo -n "Ingrese la cuenta email donde enviara la alerta: "
read dest
while [ `echo $dest | tr -dc '@' | wc -c` -ne 1 ]; do	# Hace una revision que haya un @ para que el mail sea valido
  echo -n "Cuenta email invalida. Por favor ingrese una cuenta valida: "
  read dest
done
key=`perl -MMIME::Base64 -e "print decode_base64(\"$pass64\")"`
user=`echo $src | awk -F"@" '{print $1}'`				# Extrae el nombre de usuario de la cuenta fuente
site=`echo $src | awk -F"@" '{print $2}'`				# Extrae el server de la cuenta fuente
auth=`perl -MMIME::Base64 -e "print encode_base64(\"\\000$user\\@$site\\000$key\")"` # Concatena y encripta el password en base 64
ls -l $2 > /tmp/init$$
ls -l $2 > /tmp/update$$								# Crea 2 archivos temporales para el chequeo de cambios
until ! diff /tmp/init$$ /tmp/update$$					# Revisa los cambios en la carpeta comparando los archivos
do
sleep $1
ls -l > /tmp/update$$									# Actualiza el archivo de cambios
done
(
sleep 3
echo "ehlo"
sleep 3
echo "AUTH PLAIN $auth"
sleep 3
echo "mail from: <$src>"
sleep 3
echo "rcpt to: <$dest>"
sleep 3
echo "data"
sleep 3
echo "From: <$src>"
sleep 3
echo "To: <$dest>"
sleep 3
echo "Subject: ALERTA: Directorio alterado"
sleep 3
echo ""
sleep 3
echo "El siguiente cambio se ha monitoreado en su directorio `cd $2; pwd`: "
echo `diff /tmp/init$$ /tmp/update$$`
sleep 3
echo "."
sleep 3
echo "quit"
) | openssl s_client -connect $server:$port -crlf -starttls smtp # Ingresa por pipa los comandos necesarios para enviar el mail y cerrar la cuenta.
rm /tmp/init$$		# Borra archivos temporales
rm /tmp/update$$