#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <sys/time.h>
#include <signal.h>

#define MAXL 1000	//maximo de caracteres, se usa al llamar a ifcongi 
#define MAXT 6 		//maximo de caracteres en las opciones.
#define DTINICIO 30	//anchura a graficar inicial, se usa en dos partes por eso se define
#define PERIODOINI 5 	//valor de periodo inicial

//estructura que contioene las opciones del programa
typedef struct _opc {
	int 	dt;		//delta t, tamaño de la grafica (eje x) 
	int 	periodo;	//periodo de las muestras
	int 	cambio;		//flag que indica si el usuario cambio alguna opcion
	int 	op;		//ultima opcion editada por el usuario, si cambio=1 indica que cambio { 1 - el periodo, 2 - dt }
	char *	eth;		//tarjeta de red (no se precisa de mutex para acceder a este valor, ya que solo se modifica unas ola vez	
	char	c;		//b=bytes, p=pauqets, P=promedio
} OPC;
//estructura de informacion
typedef struct formadata {
	double rxb;
	double rxp;
	double txb;
	double txp;
	int t;
} DATO;
	
OPC *opciones; 		//opciones del programa, memoria compatrida y controlada por mutex
int shmid; 			//id de la memoria compartida
pthread_mutex_t mutex;		//mutex de las opciones del programa
FILE * sdmatlab[2]; 		//1- descriptor a la entrada de matlab	0- descriptor de la salida estandar de matlab
pid_t pidmatlab; 		//pid de matlab
DATO ant,nue;			//datos antiguos y nuevos
int periodo,dt;			//periodo=tiempo entre muestras / dt=tiempo que se grafica, se grafican los ultimos a la derecha
struct itimerval timer;		//Estructura con el timeR de tiempo
struct timeval tiempo;		//Valor del timer 

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//getData2 - Funcion que se encargta de obtener los datos de ifconfig, crea una pìpa al se llamada//////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
int getData2(DATO *nd, char *tred){
	
	FILE *pfd; //descriptor de la pipa a ifconfig
	char aux[MAXL],*ini,*fin,*aux2;
	char rx[MAXL], tx[MAXL],linea[MAXL];
	int i;

	//preparamos el aux para popen
	strcpy(aux,"/sbin/ifconfig ");
	strcat(aux,tred);	
	if ((pfd = popen(aux, "r")) == NULL) {
		perror("popen en getData2");
		exit(1);
	}
	//obtenemos los datos que nos arrojo ifconfig (usamos aux como string auxiliar)
	while (feof(pfd)==0) {
		fgets(linea,MAXL,pfd);
		if(strstr(linea,"RX")!=NULL){ //esto es verdadero para la linea de RX en paquetes y para la linea con la info de los bytes
			ini = strchr(linea,(int) ':'); //donde comienzan los datos (buscamos un ':'
			fin = strchr(ini,(int) ' '); //despues del : hay que encontrar el espacio siguiente
			if(strstr(linea,"RX pa")!=NULL) {
				strncpy(aux,ini+1,strlen(ini)-strlen(fin)+1);//extraemos el numero que nos interesa
				strtok(aux," ");//lo tokenizamos para asegurarnos de que sea el puro numero
				nd->rxp=atof(aux);//retornamos las trransmisiones rx en paquetes
			}
			else { 
				strncpy(aux,ini+1,strlen(ini)-strlen(fin));
				strtok(aux," ");//lo tokenizamos para asegurarnos de que sea el puro numero
				nd->rxb=atof(aux);//retornamos el valor de rx en bytes
				ini = strchr(ini+1,(int) ':'); //como el valor de tx en bytes esta en la misma linea seguimos buscando el proximo :
				fin = strchr(ini,(int) ' ');//y luego el proximo espacio
				strncpy(aux,ini+1,strlen(ini)-strlen(fin)+1);
				strtok(aux," ");
				nd->txb=atof(aux);
			}
		} else if(strstr(linea,"TX pa")!=NULL){ //si es la linea que que viene la info de paquetres enviados
			ini = strchr(linea,':');//analogo a las anteriores
			fin = strchr(ini,' ');
			strncpy(aux,ini+1,strlen(ini)-strlen(fin));
			ini=strtok(aux," ");
			nd->txp=atof(ini);
		}
	}
	pclose(pfd);
	return(0);	
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//grafica - Funcion que se encarga de actualizar los datos y graficar, se llama cuando el timer/////////////////////
//manda la señar	SIGALRM ////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void grafica(int k){
		char c;
		int largo; 	//numero de datos a usar en fft
		//actualizamos los datos antiguos
		ant.rxb=nue.rxb;
		ant.rxp=nue.rxp;
		ant.txb=nue.txb;
		ant.txp=nue.txp;
		ant.t=nue.t;
		//y los datos nuevos con getData2
		if(getData2(&nue,opciones->eth)==1) {
			printf("Fallo el llamado a ifconfig");	
			exit(1);
		}
		//y el tiempo de la muestra 
		nue.t=ant.t+periodo;
		//extraemos opciones con mutex
		pthread_mutex_lock(&mutex);
		dt=opciones->dt;
		periodo=opciones->periodo;
		c=opciones->c;
		pthread_mutex_unlock(&mutex);
		//incertamos el nuevo dato a matlab como el delta/ el largo del period
		fprintf(sdmatlab[1],"rxb=[ rxb , (%f-%f)/(%d) ];\n",nue.rxb,ant.rxb,periodo);
		fprintf(sdmatlab[1],"rxp=[ rxp , (%f-%f)/(%d) ];\n",nue.rxp,ant.rxp,periodo);
		fprintf(sdmatlab[1],"txb=[ txb , (%f-%f)/(%d) ];\n",nue.txb,ant.txb,periodo);
		fprintf(sdmatlab[1],"txp=[ txp , (%f-%f)/(%d) ];\n",nue.txp,ant.txp,periodo);
		fprintf(sdmatlab[1],"x=[ x , %d ];\n",nue.t);
		fflush(sdmatlab[1]);
		//actualizamos la cantidad de datos a usar en fft
		largo=dt/periodo;
		//graficamos
		if(c=='b') {
			fprintf(sdmatlab[1],"subplot(2,1,1);\n");
			fprintf(sdmatlab[1],"plot(x,rxb,'r',x,txb,'b');\n");
			fprintf(sdmatlab[1],"axis([ %d %d 0 10 ]);\n",ant.t-dt,ant.t);
			fprintf(sdmatlab[1],"axis 'auto y';\n");
			fprintf(sdmatlab[1],"title('RX/TX en bytes');\n");
			fprintf(sdmatlab[1],"xlabel('Tiempo de la muestra [s]');\n");
	                fprintf(sdmatlab[1],"ylabel('Datos transmitidos [bytes/seg]');\n");
			fprintf(sdmatlab[1],"legend('RX','TX');\n");
			fflush(sdmatlab[1]);
			fprintf(sdmatlab[1],"subplot(2,1,2);\n");
			fprintf(sdmatlab[1],"hold off;\nplot(abs(fft(rxb(abs(end-%d):end))),'r');\nhold on;\n",largo);
			fprintf(sdmatlab[1],"plot(abs(fft(txb(abs(end-%d):end))),'b');\n",largo);
			fprintf(sdmatlab[1],"xlabel('Frecuencia');\n");
	                fprintf(sdmatlab[1],"ylabel('Amplitud');\n");
			fprintf(sdmatlab[1],"legend('FFT de RX','FFT de TX');\n");
			fprintf(sdmatlab[1],"title('FFT de RX/TX en bytes');\n"); 
			fflush(sdmatlab[1]);
		} else if(c=='p'){
			fprintf(sdmatlab[1],"subplot(2,1,1);\n");
			fprintf(sdmatlab[1],"plot(x,rxp,'r',x,txp,'b');\n");
			fprintf(sdmatlab[1],"axis([ %d %d 0 10 ]);\n",ant.t-dt,ant.t);
			fprintf(sdmatlab[1],"axis 'auto y';\n");
			fprintf(sdmatlab[1],"title('RX/TX en paquetes');\n");
			fprintf(sdmatlab[1],"xlabel('Tiempo de la muestra [s]');\n");
	                fprintf(sdmatlab[1],"ylabel('Datos transmitidos [paquetes/seg]');\n");
			fprintf(sdmatlab[1],"legend('RX','TX');\n");
			fflush(sdmatlab[1]);
			fprintf(sdmatlab[1],"subplot(2,1,2);\n");
			fprintf(sdmatlab[1],"hold off;\nplot(abs(fft(rxp(abs(end-%d):end))),'r');\nhold on;\n",largo);
			fprintf(sdmatlab[1],"plot(abs(fft(txp(abs(end-%d):end))),'b');\n",largo);
			fprintf(sdmatlab[1],"xlabel('Frecuencia');\n");
	                fprintf(sdmatlab[1],"ylabel('Amplitud');\n");
			fprintf(sdmatlab[1],"legend('FFT de RX','FFT de TX');\n");
			fprintf(sdmatlab[1],"title('FFT de RX/TX en paquetes');\n"); 
			fflush(sdmatlab[1]);
		} else {
			fprintf(sdmatlab[1],"subplot(2,1,1);\n");
			fprintf(sdmatlab[1],"plot(x,rxb/1024,'r',x,txb/1024,'b');\n");
			fprintf(sdmatlab[1],"axis([ %d %d 0 10 ]);\n",ant.t-dt,ant.t);
			fprintf(sdmatlab[1],"axis 'auto y';\n");
			fprintf(sdmatlab[1],"title('RX/TX en [Kbytes/seg]');\n");
			fprintf(sdmatlab[1],"xlabel('Tiempo de la muestra [s]');\n");
	                fprintf(sdmatlab[1],"ylabel('Datos transmitidos [Kbytes/seg]');\n");
			fprintf(sdmatlab[1],"legend('RX','TX');\n");
			fflush(sdmatlab[1]);
			fprintf(sdmatlab[1],"subplot(2,1,2);\n");
			fprintf(sdmatlab[1],"hold off;\nplot(abs(fft(rxb(abs(end-%d):end)/1024)),'r');\nhold on;\n",largo);
			fprintf(sdmatlab[1],"plot(abs(fft(txb(abs(end-%d):end)/1024)),'b');\n",largo);
			fprintf(sdmatlab[1],"xlabel('Frecuencia');\n");
	                fprintf(sdmatlab[1],"ylabel('Amplitud');\n");
			fprintf(sdmatlab[1],"legend('FFT de RX','FFT de TX');\n");
			fprintf(sdmatlab[1],"title('FFT de RX/TX en bytes/paquetes');\n"); 
			fflush(sdmatlab[1]);
		}	
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//*reader - Funcion que atiene la entrada y salida estandar (el menu), es ejecutada por un hilo ////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void *reader() {
	int i=0,status;
	unsigned char op,aux[MAXT],c;
	int n,k; 
	
	//ciclo de lectura (Dibujado del menu y atencion del teclado)
	while (1) {
		system("clear");		
		//nos encontramos en el menu principal, asi que esperamos a ver que ingresa el usuario
		printf("Ingrese una opcion\n\ta: Tiempo de refresco (Periodo entre muestras)\n\tb: Tamaño de grafica\n\tc: Tipo de grafico.\n\td: Salir\n");
menu1:
		scanf("%s",aux);
		op=aux[0];
		//verificamos que el usuario solo ingrece a,b,c o d
		while(op!='a'&&op!='b'&&op!='c'&&op!='d') {
			printf("Debe ingresar una opcion valida: a,b,c,d?\n");
			scanf("%s",aux);
			op=aux[0];
		}
		//ingresamos al submenu
		if(op=='a') {
			//obtenemos el valor ingresado por el ususario y verificamos que este dentro del rango aseptable
			system("clear");
			printf("Ingrese el tiempo de refresco del grafico en segundos (minimo 1s)\n");
			scanf("%s",aux);
			n=atoi(aux);
			while(n<1) {
				printf("Debe ingresar un valor mayor o igual a 1 segundos\n");
				scanf("%s",aux);
				n=atoi(aux);
			}
			//actualizamos la opcion correspondiente
			pthread_mutex_lock(&mutex);
			opciones->periodo=n;
			pthread_mutex_unlock(&mutex);
			//Se actualiza el tiempo del timer
			tiempo.tv_sec=n;
			timer.it_value=tiempo;
			timer.it_interval=tiempo;
			//Se reinicia el timer.
			setitimer (ITIMER_REAL, &timer, NULL);
		} else if (op=='b') {
			//analogo a op='a'
			system("clear");
			printf("Ingrese el tamaño del grafico de matlab (eje x) en segundos (minimo 10s)\n");
			scanf("%s",aux);
			n=atoi(aux);
			while(n<10) {
				printf("Debe ingresar un valor mayor o igual a 10 segundos\n");
				scanf("%s",aux);
				n=atoi(aux);
			}
			pthread_mutex_lock(&mutex);
			opciones->dt=n;
			pthread_mutex_unlock(&mutex);
		} else if (op=='c') {
			//analogo a op='a'
			system("clear");
			printf("Ingrese el tipo de grafico.\n\t1.RX/TX [bytes/seg]\n\t2.RX/TX [paquetes/seg]\n\t3.RX/TX [Kbytes/seg]\n");
			scanf("%s",aux);
			n=atoi(aux);
			while(n!=1&&n!=2&&n!=3){
				printf("Debe ingresar una opcion: 1-2-3?\n");
				scanf("%s",aux);
				n=atoi(aux);
			}			
			if(n==1) c='b';
			else if(n==2) c='p';
			else if(n==3) c='P';
			pthread_mutex_lock(&mutex);
			opciones->c=c;
			pthread_mutex_unlock(&mutex);			
			grafica(0);
		} else if (op=='d'){
			//limpiesa 
			if (shmdt((OPC *) opciones) < 0)
				printf("No se puede despegar la memoria compartida\n");
			if (shmctl(shmid,IPC_RMID,(struct shmid_ds *) 0) < 0)
				printf("No se puede eliminar la memoria compartida\n");
			pthread_mutex_destroy(&mutex);
			//cerramos matlab y esperamos a que cierre
			fprintf(sdmatlab[1], "\n exit\n"); fflush(sdmatlab[1]);
    			waitpid(pidmatlab, &status, 0);
			fclose(sdmatlab[1]);
			//salimos
			exit(0);
		} 
	}
}
int main(int argc, char * argv[]){
	if(argc < 2) {
		printf("Tiene que ingresar la tarjeta de red como argumento.\n");
		exit(1);
	}
	pthread_t tid; 		//tid de atendedor de esntrada estandar 
    	int i;
	int error;		//error al crear hilo
	int pfdmatlab[2]; 	//pipa a matlab
	int rxb,txb,rxp,txp; 	//rxb,txb= rx y tx en bytes 	rxp,txp= rx y tx en paquetes
	int antiguos[4];	//rxb,rxp,txb,txp
	key_t shmkey; 		//llave de la memoria compartida
	int t=0;		//tiempo de la muestra
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Iniciamos el programa llamando a matlab en un hijo (fork) y creando una pipa para poder enviarle mensajes.////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Create a pipe.
    	if (pipe(pfdmatlab) < 0) {
        	perror("pipe");
        	exit(1);
    	}
	//Create a child process.
   	if ((pidmatlab = fork()) < 0) {
        	perror("fork");
	        exit(1);
    	}
    	// The child process executes matlab.
    	if (pidmatlab == 0) {
      	int junk;
        	// Attach standard input of this child process to read from the pipe.
	        dup2(pfdmatlab[0],0);
	        //dup2(pfdmatlab[1],1);
	        junk = open("/dev/null", O_WRONLY);
	        dup2(junk, 1);  /* throw away any error message */
	        dup2(junk, 2);  /* throw away any error message */
	        execlp("matlab", "matlab", "-nodesktop", 0);
	        //execlp("octave", "octave", "-i", 0);
	        perror("exec");
	        exit(-1);
    	}
	//configuramos la pipa de matlab para usar fscanf y fprintf
     	sdmatlab[0]=fdopen(pfdmatlab[0],"r");
   	sdmatlab[1]=fdopen(pfdmatlab[1],"w");
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//configuracion del hilo y mutex para manejar la entrada y salida estandar./////////////////////////////////////////
	//tambien se inicializan las opciones por defecto //////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//inicializamos el mutex
	pthread_mutex_init(&mutex,NULL);
	//creamos y aderimos memoria compartida
	if((shmkey=ftok("/bin/ls",34))==(key_t)-1){
		printf("No se pudo obtener la llave de la memoria compartida\n");
		exit(15);
	}
	if((shmid=shmget(shmkey,sizeof(OPC),0777 | IPC_CREAT)) < 0) {
		printf("No se pudo CREAR la memoria compartida\n");
		exit(13);
	}
	if((opciones=(OPC *)shmat(shmid,(char *)0,0))==(OPC *)-1){
		printf("No se puede ADERIR la memoria compartida: %d\n",opciones);	
		exit(14);
	}	
	//inicializamos las opciones (por defecto)
	//la primera vez accedemos sin mutex, ya que el otro hilo quye va a accederlas todavia no esta creado
	opciones->periodo=PERIODOINI; 		//2 segundos entre cada muestra
	opciones->dt=DTINICIO;			//tamaño del grafico de matlab (eje x)
	opciones->eth=argv[1];			//tarjeta de red a cul hacerle ifconfig
	opciones->c='b';			////b=bytes, p=pauqets, P=promedio
	//creamos el hilo
	if (error = pthread_create(&tid, NULL, reader, NULL)) {
      		fprintf(stderr, "No se pudo crear el hilo: %s\n", strerror(error));
      		exit(12);
	}
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//inicializamos las ultimas opciones y el grafico //////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//inicializamos los datos 
	if(getData2(&nue,opciones->eth)==1) {
		printf("Fallo el llamado a ifconfig por segunda vez");	
		exit(1);
	}
	nue.t=0;	
	dt=DTINICIO;
	periodo=PERIODOINI;;
	//inicializamos las variables en matlab
	fprintf(sdmatlab[1],"rxb=[ 0 ];\n");		//velocidad de transmision en bytes/s
	fprintf(sdmatlab[1],"rxp=[ 0 ];\n");		//velocidad de recepcion en bytes/s
	fprintf(sdmatlab[1],"txb=[ 0 ];\n");		//velocidad de transmision en paquetes/s
	fprintf(sdmatlab[1],"txp=[ 0 ];\n");		//velocidad de recepcion en paquetes/s
	fprintf(sdmatlab[1],"x=[ -1 ];\n");	//el tiempo que en que se realizo la muestra
	fflush(sdmatlab[1]);
	//ploteamos
	fprintf(sdmatlab[1],"subplot(2,1,1);\n");
	fprintf(sdmatlab[1],"plot(x,rxb,x,txb);\n");
	fflush(sdmatlab[1]);
	fprintf(sdmatlab[1],"subplot(2,1,2);\n");
	fprintf(sdmatlab[1],"plot(x,rxp,x,txp);\n");
	fflush(sdmatlab[1]);
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Com mienza el ciclo principal pero antes preparamos el timer para que nos despierte cada periodo tiempo///////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//Se rellena el tiempo inicial del timer con periodo segundos
	pthread_mutex_lock(&mutex);
	tiempo.tv_sec=opciones->periodo;
	pthread_mutex_unlock(&mutex);
	tiempo.tv_usec=0;
	//Se rellenan los datos del timer
	timer.it_value=tiempo;
	timer.it_interval=tiempo;
	//Cuando el timer termine llama a grafica()
	signal (SIGALRM, grafica);
	//Se pone en marcha el timer.
	setitimer (ITIMER_REAL, &timer, NULL);
	while(1) {
		//nos dormimos, despertamos cuando el tiemr nos avise y se ejecuta grafica
		pause();
	}
}
