#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

#define DISPAROS_TOTAL  10
#define ACIER "acierto"

void ocupar( int , int , int , int );
int ocupado( int , int );
int tablero[10][10]={0};
int aciertos=0;

int main (int argc, char *argv[])
{
  pid_t pid; 
  int pfd[2];
  int i, status;
  int tipo=0;
  int orien; 
   int posX, posY; 
   FILE *sd; 
   
  if (argc !=4){
     printf("Utilice \"bnv1 <archivo_portaviones> <archivo_fragata> <archivo_submarino>\" \n");
    exit (-1);
  }

  //Creamos una pipa:
  if (pipe(pfd) < 0) {
    perror("pipe");
    exit(1);
  }

  //Creamos un proceso hijo:
  if((pid = fork()) < 0) {
    perror("fork");
    exit(1);
  }

  //El proceso hijo ejecuta gnuplot:

  if(pid==0){
    dup2(pfd[0],0);
    close(pfd[1]);
    execlp("gnuplot", "gnuplot", 0);
    perror("exec");
    _exit(127);
  }

  //No vamos a leer desde la pipa
  close(pfd[0]);
  sd = fdopen(pfd[1], "w");

  fprintf(sd, "set title \"Batalla Naval v1.0\"\n");
  fprintf(sd, "set xrange [0:10];set yrange [0:10];set nokey;set multiplot\n");
   
    printf("\n\n\nBIENVENIDO AL JUEGO:  Batalla Naval \n"); 
  while( tipo!=5) {
    printf("\nIngrese el numero correspondiente a lo que desea hacer: \n ");
    printf("(1)Portaviones   (2)Fragata   (3)Submarino   (5)Comenzar Partida \n");
    printf("Eleccion: ");
    scanf("%d",&tipo);
  
     switch (tipo) {  
	
	
        case 1:
	 printf("Como quiere poner el Portaviones?\n (1)Horizontal  (2)Vertical\n");
	 scanf("%d",&orien); 
	 while (1>orien || orien>2 )  {
	 printf("Ingrese un numero valido\n");
	 scanf("%d",&orien);           
	  }
	 printf("Ingrese la posicion en la cual desea ubicar el Portaviones\n");
	 printf("Posicion X (valor entre 0 y 7):");
	 scanf("%d",&posX);
	 while (posX>7 ||posX<0)
	   {
	      printf("Numero invalido \nIngrese un numero valido (0 y 7): ");
	      scanf("%d",&posX);	
	   }
	 printf("Posicion Y (valor entre 0 y 9):");
	 scanf("%d",&posY);
	 while (posY>9 ||posY<0)
	   {	      
	      printf("Numero invalido \nIngrese un numero valido (0 y 9): ");
	      scanf("%d",&posY);
	   }

	 if (ocupado(posX,posY)==1) 
	  {
	     printf("\nEn esta posicion ya hay una nave!\n");
	     printf("Intente Nuevamente\n\n");
	  }
	
	 else if (orien==1)
	  {  
	 fprintf(sd, "plot \"%s\" using ($1+%d):($2+%d) with lines  \n",argv[tipo] , posX, posY);
	 fflush(sd);
	 }
	 else if (orien==2)
	   {  
	 fprintf(sd, "plot \"%s\" using ($2+%d):($1+%d) with lines  \n",argv[tipo] , posX, posY);
	 fflush(sd);
	 }
	 ocupar(tipo , posX, posY,orien);
	 break;

	
       case 2:
	 printf("Como quiere poner la Fragata?\n (1)Horizontal  (2)Vertical\n");
	 scanf("%d",&orien);
	 while (1>orien || orien>2 )  {
	 printf("Ingrese un numero valido\n");
	 scanf("%d",&orien);           
	  }
	 printf("Ingrese la posicion en la cual desea ubicar la Fragata\n");
	 printf("Posicion %s [valor entre 0 y 8]:");
	 scanf("%d",&posX);
	 while (posX>8 ||posX<0)
	   {
	      printf("Numero invalido \nIngrese un numero valido (0 y 8): ");
	      scanf("%d",&posX);
	   }
	 printf("Posicion Y [valor entre 0 y 9]:");
	 scanf("%d",&posY);
	 while (posY>9 ||posY<0)
	   {
	       printf("Numero invalido \nIngrese un numero valido (0 y 9): ");
	       scanf("%d",&posY);
	   }
	 if (ocupado(posX,posY)==1) 
	  {
	     printf("\nEn esta posicion ya hay una nave!\n");
	     printf("Intente Nuevamente\n\n");
	  }
	
	 else if (orien==1)
	  {  
	 fprintf(sd, "plot \"%s\" using ($1+%d):($2+%d) with lines  \n",argv[tipo] , posX, posY);
	 fflush(sd);
	  }
	 else if (orien==2)
	   {  
	 fprintf(sd, "plot \"%s\" using ($2+%d):($1+%d) with lines  \n",argv[tipo] , posX, posY);
	 fflush(sd);
	 }
	ocupar(tipo , posX, posY,orien);
	break;
       
	
	case 3: 
	 printf("Como quiere poner el Submarino?\n (1)Horizontal  (2)Vertical\n");
	 scanf("%d",&orien);
         while (1>orien || orien>2 )  {
	 printf("Ingrese un numero valido\n");
	 scanf("%d",&orien);           
	  }
	 printf("Ingrese la posicion en la cual desea ubicar el Submarino\n");
	 printf("Posicion X [valor entre 0 y 9]:");
	 scanf("%d",&posX);
	 while (posX>9 ||posX<0)
	   {
	      printf("Numero invalido \nIngrese un numero valido (0 y 9): ");
	      scanf("%d",&posX);
	   }
	 printf("Posicion Y [valor entre 0 y 9]:");
	 scanf("%d",&posY);
	 while (posY>9 ||posY<0)
	   {
	       printf("Numero invalido \nIngrese un numero valido (0 y 9): ");
	       scanf("%d",&posY);
	   }
	 if (ocupado(posX,posY)==1) 
	  {
	     printf("\nEn esta posicion ya hay una nave!\n");
	     printf("Intente Nuevamente\n\n");
	  }
	
	 else if (orien==1)
	  {  
	 fprintf(sd, "plot \"%s\" using ($1+%d):($2+%d) with lines  \n",argv[tipo] , posX, posY);
	 fflush(sd);
	  }
	 else if (orien==2)
	   {  
	 fprintf(sd, "plot \"%s\" using ($2+%d):($1+%d) with lines  \n",argv[tipo] , posX, posY);
	 fflush(sd);
	  }
	 ocupar(tipo , posX, posY,orien); 
	 break;
	 
	 case 5 : 
           printf("\nComenzando Partida..............\n\n");
	 break;

         default :
	 printf("\nIngrese una opcion valida\n\n");
	 break;
      }
  }
   
  printf("Tiene %d disparos para intentar undir las naves de su enemigo",DISPAROS_TOTAL);

  for(i=0; i<DISPAROS_TOTAL; i++){
      printf("\nDisparo %d\n",i+1);
  do {
      printf("Posicion X: ");
      scanf("%d",&posX);
      if (posX>9||posX<0)
       {  
       printf("Dispare dentro de la zona de guerra.\n");
       printf("No tiene para que morir gente inocente!\n");
	   }
     }
     
     while (posX>9||posX<0);
     
  do {
     printf("Posicion Y: ");
     scanf("%d",&posY);
     if (posY>9||posY<0) 
       {	  
       printf("Dispare dentro de la zona de guerra.\n");
       printf("No tiene para que morir gente inocente!\n");
	   }
     }     
      
  while (posY>9 || posY<0); 
     
	  if(ocupado(posX,posY)==1){
	     fprintf(sd, "plot \"%s\" using ($1+%d):($2+%d) with lines  \n", ACIER, posX, posY);
	     fprintf(sd, "plot \"%s\" using ($1+%d):($3+%d) with lines  \n", ACIER, posX, posY);
	     fflush(sd);
	     aciertos++;
	  }
	  else 
	    { 	  
	       fprintf(sd,"set parametric\n");
	       fprintf(sd,"plot [0:2*pi] (0.5*sin(t)+0.5+%d),(0.5*cos(t)+0.5+%d) \n",posX,posY);
	       fflush(sd); 
	    }
      	  
  }
  printf("\n\nHa realizado %d aciertos\n", aciertos);
  printf("\nGAME OVER\n\n");
  
    
    fprintf(sd, "\n exit"); 
    fflush(sd);
    
    
    fclose(sd);
    waitpid(pid, &status, 0);

     /*
     * Exit with a status of 0, indicating that
     * everything went fine.
     */
    return(0);
}

void ocupar(int tipo, int X ,int Y ,int orien){

  switch (tipo) {
  case 1:
   if (orien==1){
      tablero[X+2][Y]=1;
      tablero[X+1][Y]=1;
      tablero[X][Y]=1;
       }
  else if (orien==2){ 
     tablero[X][Y+2]=1;
      tablero[X][Y+1]=1;
      tablero[X][Y]=1;
       }
   
  case 2:
   if (orien==1) {
      tablero[X+1][Y]=1;
      tablero[X][Y]=1;
       }
    else if (orien==2){ 
      tablero[X][Y+1]=1;
      tablero[X][Y]=1;
       }  
     
     
  case 3:
   tablero[X][Y]=1;
  }
   // printf("Ocupar%d %d %d", X, Y, tablero[X][Y]);
}

int ocupado(int X, int Y){
   
  if(tablero[X][Y]==1) 
    return(1);
        
  else
    return(0);
}

   
   


  
  


  
  

