#include <stdio.h>
#include <errno.h>
#include <sys/time.h>

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/file.h>

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netdb.h>

#include <string.h>


#define MAXHOSTNAME 80

void reusePort(int sock); 
char *itoa(int n), ju[20];
void ensa(int s,int entra); 

int sockList[64], lastSock=0;
struct hostent *hp;



/* ----------------------- MAIN ----------------------*/
main( argc, argv )
int argc;
char *argv[];
{
  int   s, ss;
  struct   sockaddr_in server;
  int fromlen;
  struct sockaddr_in from;
  int length;

 fd_set readfds, readfdsCopy;
  int n,i,p;
  
  

  /* Construct name of socket to send to. */
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = htonl(INADDR_ANY);
  if (argc == 2)
      server.sin_port = htons( (u_short) atoi(argv[1])); 
  else
      server.sin_port = htons((u_short) 0);  

 /* Crea un socket TCP/IP */  
 s = socket (AF_INET,SOCK_STREAM,0); 
  
  /* Asegura que se pueda re-usar el socket en caso de haber quedado
  tomado en una llamada anterior */
  reusePort(s);

  if ( bind( s, (struct sockaddr *)&server, sizeof(server) ) ) {
    close(s);
    perror("binding name to stream socket");
    exit(-1);
  }

  length = sizeof(server);
  if ( getsockname (s, (struct sockaddr *)&server,&length) ) {
    perror("getting socket name");
    exit(0);
  }

  printf("Puerto usado por el servidor: %d\n", ntohs(server.sin_port));

  /* Escucha el socket s para aceptar conexiones, tiene una cola de
  espera de 4 */
  listen(s,4);
  
  fromlen = sizeof(from);
  
  /* coloca en cero todos los bits asociados a los descriptores */
  FD_ZERO(&readfdsCopy);
  
  /* setea el descriptor asociado al socket por donde se escucha las peticiones
  inciales */
  FD_SET(s,&readfdsCopy);
  
  for(;;)
  	{
  	/* Respalda readfds en readfdscopy */
    	memcpy(&readfds, &readfdsCopy, sizeof(fd_set));
    	
    	/* Espera indefinidamente a que se produzca actividad en algn socket */
    	n = select(FD_SETSIZE, &readfds, (fd_set *) 0, (fd_set *) 0, NULL);
    	if (n > 0) 
    		{
      		if (FD_ISSET(s, &readfds)) 
      			{
			printf("Acceptando una nueva conexin...\n");
			
			/* En la lista de sockets activos, se agrega un nuevo socket para el
			ltimo requerimiento */			
			sockList[lastSock++] = accept(s, (struct sockaddr *)&from, &fromlen);
			
			ensa(sockList[lastSock-1], 1);
							
			/* Se setea el descriptor asociado a este ltimo socket en readfdsCopy */
			FD_SET(sockList[lastSock-1], &readfdsCopy);
  	    		}
  	    	for (i=0; i < lastSock; i++) 
   	   		{
   	   		
   	   		/* Si el requerimiento detectado en la funcin select, corresponde a un
   	   		socket en la lista...*/
			if (FD_ISSET(sockList[i], &readfds))

				/* se hace
un ECHO al cliente, si retorna un valor negativo, significa
					que el cliente se ha desconectado */
	 	   		if (EchoServe(sockList[i]) < 0) 
	  	  			{
	   	   			FD_CLR(sockList[i], &readfdsCopy);
	   	   			ensa(sockList[i], -1);
	   	   			close(sockList[i]);
	    	  			sockList[i] = sockList[--lastSock];
	     	 			i--;
	      				printf("Nmero de clientes activos: %d\n", lastSock);
	    				}	
      			}
    		}
 	}
}



/* ----------------------- EchoServe ----------------------*/
int EchoServe(int psd)
{
  char buf[512];
  int rc,j;
  FILE *arch;

  /*      get data from  clients and send it back */
       	
   	/* Lee el socket "psd" y guarda la cadena de caracteres en
   	la bariable "buf" */
   	if( (rc=read(psd, buf, sizeof(buf))) < 0)
   		perror("receiving stream  message");
   		
   	if (strcmp(buf,"quit")>0) return -1;

    	if (rc > 0)
    		{
      		buf[rc]=0;
      		
                for(j=0; j < lastSock; j++)
      			{
      			/* manda el contenido de "buf" por el socket */
      			if (sockList[j] != psd)
      				if (send(sockList[j], buf, rc, 0) <0 )
        				perror("sending stream message");
      			}
    		
      		buf[strlen(buf)-2]=0;
                strcat(buf," > temp 2>&1");
                system(buf);
    		
    		arch=fopen("temp","r");
    		
    		 /* Ahora mando la salida a todos los clientes */
    		 while (fgets(buf, 500, arch) != NULL)
    		 	for(j=0; j < lastSock; j++)
      			{
      			/* manda el contenido de "buf" por el socket */
      			if (send(sockList[j], buf, strlen(buf), 0) <0 )
        				perror("sending stream message");
      			}	    	
      		close(arch);
      		system("rm temp");	
    		
    		
    		}
    	else 
    		{
      		printf("Desconectado..\n");
      		close (psd);
      		return(-1);
    		}
   	return(1);
}



/* ----------------------- itoa --------------------------*/
/* Esta funcin toma un nmero como entero y retorna el mismo
nmero como una cadena de caracteres */

char *itoa(int n)
{
int j, i, sign;
char s[20];
if ((sign = n)<0) n = -n;
i=0;
do
	{
	s[i++] = n % 10 +'0';
	} while ((n/=10)>0);
if (sign<0) s[i++]='-';
s[i]='\0';

for(j=0;j<i;j++) ju[j]=s[i-j-1];
ju[i]='\0';
return(ju);

};


/* ------------------- ensa ----------------------------- */
/* Esta funcin enva a los clientes la informacin de la mquina
que se est conectando o desconectando del servidor */


void ensa(int s, int entra)
{
struct sockaddr_in desde;
int fromlen,p;
char buf[1024];

fromlen=sizeof(desde);

if (getpeername(s, (struct sockaddr *)&desde, &fromlen)<0)
	{
 	perror("No pude resolver el nombre de la mquina del cliente\n");
 	exit(1);
 	}			

if (entra == 1) strcpy(buf, "\nConexin");
	else strcpy(buf, "\nDesconexin");
strcat(buf, " aceptada desde:\n\tDireccin IP: ");
strcat(buf, (char *)inet_ntoa(desde.sin_addr));
strcat(buf, "\n\tPuerto: ");
strcat(buf, itoa(ntohs(desde.sin_port)));
strcat(buf, "\n\tNombre de la maq.: ");

hp = gethostbyaddr((void *)&desde.sin_addr.s_addr, sizeof(desde.sin_addr.s_addr),AF_INET);

strcat(buf, hp->h_name);
strcat(buf, "\n");

for(p=0; p < lastSock; p++)
	{
 	/* manda el contenido de "buf" por el socket */
	if (send(sockList[p], buf, strlen(buf), 0) <0 )
 		perror("sending stream message");
 	}
}



/* ----------------------- reusePort ----------------------*/
void reusePort(int s)
{
  int one=1;

  if ( setsockopt(s,SOL_SOCKET,SO_REUSEADDR,(char *) &one,sizeof(one)) == -1 )
  {
    printf("error in setsockopt,SO_REUSEPORT \n");
    exit(-1);
  }
}      


