public class Robot {
   private Robot() { 
      this(new Vector2D(), new Vector2D(), 0, null);
   }
   public Robot(Vector2D position, Vector2D velocity, double sensorRange, MyWorld w) {
      pos = position;
      v = velocity;
      world = w;
      Vector2D dir = v.getUnitary();
      rightSensor = new DistanceSensor(new Vector2D(dir.getY(), -dir.getX()), sensorRange);
      frontSensor = new DistanceSensor(dir, sensorRange);
      leftSensor = new DistanceSensor(new Vector2D(-dir.getY(), dir.getX()), sensorRange);
      pilot = new Pilot (this);
   }
   public Vector2D getPosition() {
      return pos;
   }
   public Vector2D getVelocity() {
      return v;
   }
   public DistanceSensor getRightSensor() {
      return rightSensor;
   }
   public DistanceSensor getFrontSensor() {
      return frontSensor;
   }
   public DistanceSensor getLeftSensor() {
      return leftSensor;
   }
   public void turnLeft(){
      v.turnLeft();
      rightSensor.turnLeft();
      frontSensor.turnLeft();
      leftSensor.turnLeft();
      System.out.println("turning left...");
      return; 
   }
   public void turnRight(){
      v.turnRight();
      rightSensor.turnRight();
      frontSensor.turnRight();
      leftSensor.turnRight();      
      System.out.println("turning right...");
      return; 
   }
   public void moveDelta_t(double delta_t) {
      pilot.setCourse();
      pos = pos.plus(v.times(delta_t));      
   }
   public String getDescription() {
      return pos.getDescription();
   }
   public String toString() {
      return pos.toString()+ rightSensor.toString() + frontSensor.toString()+leftSensor.toString();
   }
   public void markRoute(Maze m){
       m.markPoint(pos);
   }
   public class DistanceSensor { // only used in Robot, therefore it is an internal class.
      public DistanceSensor(Vector2D direction, double rang) {
         dir = direction;
         range = rang;
      }
      public void turnLeft(){
         dir.turnLeft();
      }
      public void turnRight() {
         dir.turnRight();
      }
      public boolean senseWall(){
         double distance = 0;
         Vector2D point=pos;
         while(distance < range) {
            if(world.isThere_a_wall((int)point.getX(),(int)point.getY()))
               return true;
            distance+=presition;
            point = pos.plus(dir.times(distance));
         }
         return false;  // it means there is no wall within range.
      }
      public String toString() {
         return " "+senseWall();
      }
      
      private Vector2D dir;  // orientation direction with respect to forward robot's direction
      private double range;
      private static final double presition = 0.4;
   }
      
   private Vector2D pos;
   private Vector2D v;
   private MyWorld world;
   private DistanceSensor rightSensor, frontSensor, leftSensor;
   private Pilot pilot;
}