#ifndef SPRING_H
#define SPRING_H
#include <string>
#include "PhysicsElement.h"
#include "CVector.h"
#include "Ball.h"
class Ball;

class Spring: public PhysicsElement {
private:
   static int id;  // Spring identification
   const double restLength;
   const double stiffness;
   Ball * a_end, *b_end;
   Spring();   // nobody can create a block without state
public:
   Spring(double restLength, double stiffness);
   void attachEnd (Ball *sa);
   CVector getAendPosition() const;
   CVector getBendPosition() const;
   CVector getForce(const Ball * pball) const;
   void computeNextState(double delta_t, MyWorld *w);
   void updateState();
   virtual string getDescription() const;
   virtual string getState() const;
};
#endif