#include "Spring.h"

int Spring::id=0;  // Spring identification
Spring::Spring():Spring(0,0){   // nobody can create a block without state
}
Spring::Spring(double restLength, double stiffness):PhysicsElement(id++), 
              restLength(restLength), stiffness(stiffness) {
   a_end = b_end = NULL;
}
void Spring::attachEnd (Ball *pb) {  // note: we attach a spring to a ball, 
   if(a_end==NULL)                   //       not the other way around.
       a_end = pb;
   //to be coded by you
   pb->attachSpring(this);
}
CVector Spring::getAendPosition() const {
   CVector l(restLength,0);
   if (a_end != NULL)
      return a_end->getPosition();
   if (b_end != NULL)
      return b_end->getPosition()-l;
}
CVector Spring::getBendPosition() const {
   // to be coded by you
}
CVector Spring::getForce(const Ball * pball) const {
   CVector force;
   if ((a_end == NULL) || (b_end == NULL))
      return force;
   if ((pball != a_end) && (pball != b_end))
      return force;     
   // to be coded by you
}
void Spring::computeNextState(double delta_t, MyWorld *w){
} 
void Spring::updateState(){
}

string Spring::getDescription() const {
    return "Spring_"+ std::to_string(getId())+":a_end,\tb_end";
}
string Spring::getState() const {
    // to be coded by yoou
}
