#ifndef BALL_H
#define BALL_H
#include <string>
#include <vector>
#include "PhysicsElement.h"
#include "MyWorld.h"
#include "CVector.h"
#include "Spring.h"
class Spring;

using namespace std;
class PhysicsElement;
class MyWorld;

class Ball: public PhysicsElement {
private:
   static int id;  // Ball identification number
   const double mass;
   const double radius;
   CVector pos_t;     // current position at time t
   CVector pos_tPlusDelta;  // next position in delta time in future
   CVector speed_t;   // speed at time t
   CVector speed_tPlusDelta;   // speed in delta time in future
   CVector a_t;
   CVector a_tMinusDelta;
   vector<Spring *> springs;
   
   Ball();
public:
   Ball(double mass, double radius, CVector position, CVector speed);
   double getRadius() const;
   CVector getSpeed() const;
   CVector getPosition() const;
   double getMass() const;
   void attachSpring(Spring *s);
   CVector getNetForce() const;
   void computeNextState(double delta_t, MyWorld * world);
   bool collideWith(const Ball *b) const;  
   void updateState();
   friend ostream & operator<< (ostream &, const Ball &);
   virtual string getDescription() const;
   virtual string getState() const;
};
#endif