#include "PhysicsElement.h"
#include "Ball.h"

int Ball::id=0;

Ball::Ball():PhysicsElement(id++),mass(1.0), radius(0.1),
             pos_t(0,0), speed_t(0,0){   // nobody can create a block without state
}

Ball::Ball(double mass, double radius, CVector position, CVector speed): 
            PhysicsElement(id++),mass(mass),radius(radius){
      pos_t = position;
      speed_t = speed;
}
double Ball::getRadius() const {
   return radius;
}
CVector Ball::getSpeed() const {
    return speed_t;
}
CVector Ball::getPosition() const {
    return pos_t;
}
double Ball::getMass() const {
    return mass;
}
void Ball::attachSpring(Spring *s){
    springs.push_back(s);
}
CVector Ball::getNetForce() const{
// to be coded by you
}
void Ball::computeNextState(double delta_t, MyWorld * world) {
  Ball * pb;  // Assumption: on collision we only change speed.   
  if ((pb=world->findCollidingBall(this))!= NULL){ /* elastic collision */
     double massFactor = 2*pb->getMass()/(mass+pb->getMass());
     CVector centersDifference = pos_t - pb->getPosition();
     double dotProduct = (speed_t-pb->getSpeed()) % centersDifference ;
     speed_tPlusDelta= speed_t - massFactor*dotProduct*centersDifference/centersDifference.moduleSquared(); 
     pos_tPlusDelta = pos_t;
  } else {
// to be coded by you
  }
}
bool Ball::collideWith(const Ball* pb) const {
   if (this == pb) return false;
   const Ball& b=*pb;
   CVector centersDifference = pos_t - b.getPosition();
   bool closeEnougth = ...
   double dotProduct = ... ;
   bool approaching = dotProduct < 0;
   return closeEnougth && approaching;
}
void Ball::updateState(){
     pos_t = pos_tPlusDelta;
     speed_t = speed_tPlusDelta;
     a_tMinusDelta=a_t;
}
string Ball::getDescription() const {
   return "Ball_" + std::to_string(getId())+":x,y";
}

string Ball::getState() const{
// to be coded by you
}

ostream & operator<< (ostream & os, const Ball & b) {
  os << b.pos_t;
  return os;
}