#include "MyWorld.h"
#include <iostream>
#include <typeinfo>       // operator typeid
using namespace std;

MyWorld::MyWorld(ostream & output):out(output){
}

void MyWorld::addElement(PhysicsElement * e) {
      elements.push_back(e);
}

void MyWorld::printStateDescription(){
     out <<"Time\t";
     for (PhysicsElement *e:elements)
       out << e->getDescription() + "\t";
     out << endl;
}

void MyWorld::printState(double t){
// to be coded by you
}

void MyWorld::simulate (double delta_t, double endTime, double samplingTime) {  // simulate passing time
      double t=0;
      printStateDescription();
      printState(t);
      while (t<endTime) {
         for(double nextStop=t+samplingTime; t<nextStop; t+=delta_t) {
           for (PhysicsElement * e: elements)   // compute each element next state based on current global state  
              e->computeNextState(delta_t,this); // compute each element next state based on current global state
           for (PhysicsElement * e: elements)  // for each element update its state. 
              e->updateState();     // update its state
         }
         printState(t);
      }
}   

Ball* MyWorld::findCollidingBall(Ball* me) {
// to be coded by you
}  

