import java.util.*;

public class Wire implements InSignal, OutSignal {
  private OutSignal source;
  private ArrayList <InSignal> drains;
  public Wire() {
    source = null;
    drains = new ArrayList<InSignal>();
  }
  // InSignal interface
  public void inputValueChanged() {
    for ( InSignal s: drains )
       s.inputValueChanged(); 
  }
  public void connectInput(OutSignal output) {
    source = output;
    output.connectDrain(this);
  }
  public void disconnectInput() {
    if (source!=null) {
      source.removeFromDrains(this);
      source = null;
    }
  }
  public void addSource(OutSignal output) {
    source=output;
  }
  public void removeFromSource(OutSignal output) {
    if (source==output) source=null;
  }// InSignal Interface end
  
  // OutSignal interface
  public boolean getValue() {
    if (source !=null) return source.getValue();
    return true;  // it could have been false 
  }
  public void connectOutput(InSignal drain){
    if (drain != null ) {
      drains.add(drain);
      drain.addSource(this);
    }
  }
  public void connectDrain(InSignal drain) {
    if(drain!=null) drains.add(drain);
  }
  public void removeFromDrains(InSignal drain) {
    drains.remove(drain);
  }
  public void disconnectOutput(InSignal drain){
    if (drain != null) {
      drains.remove(drain);
      drain.removeFromSource(this);
    }
  }
  public void disconnectAllOutput(){
    while(drains.size()!=0) {
      drains.get(0).removeFromSource(this);
      drains.remove(0);
    }
  }
  public String getDescription() {
    if (source!=null) return source.getDescription();
    else return ("Nothing");
  }
  // OutSignal end
  public boolean hasConnectedSource(){
    return source != null;
  }
} 