import java.io.File;
import java.io.FileNotFoundException;
import java.util.*;

public class Source implements OutSignal, UpdateListener, Cloneable {
  private boolean output;
  private Simulator sim;
  private Scanner data;
  private ArrayList<InSignal> drains;
  private static int nextId=0;
  private final int id;
  private File file;

  
  {  id = nextId++;
  }
  public Source(File in, Simulator s) {
	
    sim = s;
    file = in;
    loadSource();
    drains = new ArrayList<InSignal>();
    
  }
  
  public void updateOutputValue(boolean val) {
    if(val != output) 
        output = val;
    if (data.hasNextFloat()) {
       float time = data.nextFloat();
       boolean nextValue = data.nextInt()==1;
       sim.add(new ChangeEvent(this, nextValue, time));
    }
  }
  public void loadSource(){
	  try {
	    	data= new Scanner(file);
	    } catch(FileNotFoundException ef) {
	        return;
	    }
	  float t = data.nextFloat();
	  boolean val= data.nextInt()==1;
	  sim.add(new ChangeEvent(this, val, t)); 
	  
  }
    
  public void propagateOutputValue() {
    for (InSignal drain: drains) 
      drain.inputValueChanged();
  }
  
  public boolean getValue() {
    return output;
  }
  public void connectOutput(InSignal drain) {
    if(drain!=null) {
      drains.add(drain);
      drain.addSource(this);
    }
  }
  public void connectDrain(InSignal drain) {
    if(drain!=null) drains.add(drain);
  }
  public void removeFromDrains(InSignal drain) {
    if(drain!=null) drains.remove(drain);
  }
  public void disconnectOutput(InSignal drain) {
    if(drain!=null){
      drains.remove(drain);
      drain.removeFromSource(this);
    }
  }
  public void disconnectAllOutput() {
    while (drains.size()!=0) {
       drains.get(0).removeFromSource(this);
       drains.remove(0);
    }
  }
  public String getDescription() {
    return getClass().getName().substring(1)+"_"+id;
  }
}
