import java.lang.*;
import java.util.*;
  
public class Simulator{
   private PriorityQueue<ChangeEvent> pq;
   private ArrayList<Meter> meters;
   private float currentTime;
    
   public Simulator (){
     pq = new PriorityQueue<ChangeEvent>();
     currentTime = 0;
     meters= new ArrayList<Meter>();
   }
   
   public void add (ChangeEvent e){
     pq.add(e);
   }
   
   public void addMeter(Meter meter) {
     meters.add(meter);
   }
   private void writeHeader(){
     for (Meter m: meters)
       m.writeHeader();
   }
   private void log(float time){
     for (Meter m: meters)
       m.log(time);
   }
   public void simulate() {
	  ChangeEvent event;
      ArrayDeque <ChangeEvent> simultEvent; // Array of simultaneous events
      simultEvent = new ArrayDeque <ChangeEvent>();
      writeHeader();
      while((event=pq.poll())!=null) {
         currentTime = event.getTime();
         log(currentTime);  // log state before the change
         // get all simultaneous events
         while(true) {
            simultEvent.add(event);
            event=pq.poll();
            if (event==null) break;  // done when prioriry queque is empty
            if (event.getTime()!=currentTime) { //done when event's time changes
               pq.add(event);  // undo poll to have it realy for next loop
               break;
            }
          }
         // update output for each element realy to change
         for (ChangeEvent e: simultEvent)
            e.performUpdate(this);
         // remove element and propagate its output update to each drain
         while ((event=simultEvent.poll())!=null)
            event.notifyUpdate();
         log(currentTime);   // log state after the changes      
      }
   }
   public float getTime() {
      return currentTime;
   }
   public void resetSimulator(){////////////////////////////////
	   //pq.clear();
	   currentTime = 0;	   
   }
   
}
