import java.util.*;

public class OrGate extends Gate implements Component{
  public OrGate (float delay, Simulator s) {
    super(delay, nextId++, s);
    sources= new ArrayList<OutSignal>();
  }
  public OrGate (Simulator s) {
     this(OrGate.delay, s);
  }
  public void connectInput(OutSignal output){
    sources.add(output);
    output.connectDrain(this);
  }
  public void disconnectInput(){
    while(sources.size() != 0) {
      sources.get(0).removeFromDrains(this);
      sources.remove(0);
    }
  }
  public void addSource(OutSignal output) {
    sources.add(output);
  }
  public void removeFromSource(OutSignal output){
    sources.remove(output);
  }
  public boolean computeOutput(){
    boolean result=false;
    for ( OutSignal in: sources)
       result = result || in.getValue(); 
    return result;
  }
  public boolean hasConnectedSource() {
    return sources.size()>0;
  }
  public void setDelay(float new_delay){
	  OrGate.delay = new_delay;
  }
  public float getDelay(){
	  return OrGate.delay;
  }
  private ArrayList<OutSignal> sources;
  private static int nextId = 0;
  private static float delay = 2;
}