import java.util.*;

public class NorGate extends Gate implements Component{
  public NorGate (float delay, Simulator s) {
    super(delay, nextId++, s);
    sources= new ArrayList<OutSignal>();
  }
  public NorGate (Simulator s) {
     this(NorGate.delay, s);
  }
  public void connectInput(OutSignal output){
    sources.add(output);
    output.connectDrain(this);
  }
  public void disconnectInput(){
    while(sources.size() != 0) {
      sources.get(0).removeFromDrains(this);
      sources.remove(0);
    }
  }
  public void addSource(OutSignal output) {
    sources.add(output);
  }
  public void removeFromSource(OutSignal output){
    sources.remove(output);
  }
  public boolean computeOutput(){
    boolean result=false;
    for ( OutSignal in: sources)
       result = result || in.getValue(); 
    return !result;
  }
  public boolean hasConnectedSource() {
    return sources.size()>0;
  }
  public void setDelay(float new_delay){
	  NorGate.delay = new_delay;
  }
  public float getDelay(){
	  return NorGate.delay;
  }
  private ArrayList<OutSignal> sources;
  private static int nextId = 0;
  private static float delay = 2;
}
