/**
 * @author      Oscar Silva <oscar.silvam@alumnos.usm.cl>
 * @version     1.7                 (current version number of program)
 * @since       2013-05-15          (the version of the package this class was first added to)
 */
import java.util.*;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class Meter implements InSignal{
	/**
	* Crea un ArrayList de OutSignal llamado sources.
	*/
   private ArrayList<OutSignal> sources;
   /**
   * Define el objeto out de la clase PrintStream.
   */
   private PrintStream out;
   /**
    * Define la variable nextId y la setea en cero.
    */
   private static int nextId=0;
   /**
    * Define la variable id correspondiente a cada compuerta.
    */
   private final int id;
   /**
    * Define el objeto File que resivira al parametro en el constructor.
    */
   private File file;
   {  id = nextId++;
   }
   /**
    * Constructor de la clase Meter.
    *
    * Crea el constructor de la clase Meter, creando el objeto PrintStream y un ArrayList
    * de señales de entrada.
    *
    * @param os Archivo en el cual se guardaran las mediciones del circuito.
    * @return  Retorna Error si no se logra crear el objeto PrintStream.
    */
   public Meter (File os) {
      file = os; 
      clearMeter();
      sources = new ArrayList<OutSignal>();
   }
   /**
    * Vuelve a crear el objeto PrintStream.
    *
    * Vuelve a crear el objeto PrintStream para volver a guardar nuevos valores en el archivo
    * de salida del objeto Meter.
    *
    * @return  Retorna Error si no se logra crear el objeto PrintStream.
    */
   public void clearMeter(){
	   try {
		   out = new PrintStream(file);
	   } catch(FileNotFoundException ef) {
	       
		   return;
	   }
	   
   }
   /**
   * Funcion de la interfaz Drawable no implementada en esta clase.
   */
    public void inputValueChanged()
    {
        return;
    }
    /**
    * Agrega la salida del circuito donde se medira usando el Meter.
    *
    * Agrega la salida del circuito donde se medira usando el Meter a la entrada del Meter.
    *
    * @param output Corresponde al valor entregado por el Wire donde se esta midiendo.
    */
    public void connectInput(OutSignal output)
    {
        sources.add(output);
        output.connectDrain(this);
    }
    /**
    * Desconecta las entradas relacionadas a Meter. 
    *
    * Desvincula todas las conexiones que estén puestas en
    * la interfaz gráfica del objeto Meter.
    */
    public void disconnectInput() 
    {    
        while(sources.size() != 0) {
          sources.get(0).removeFromDrains(this);
          sources.remove(0);
         }    
    }
    /**
    * Añade el valor a medir del circuito al ArrayList sources.
    *
    * @param output Corresponde al valor a medir por el meter.
    */
    public void addSource(OutSignal output)
    {
        sources.add(output);
    }
    /**
    * Remueve el valor medido del ArrayList source.
    *
    * Remueve el valor medido por el Meter del ArrayList source.
    *
    * @param output Corresponde al valor medido del circuito por el meter.
    */
    public void removeFromSource(OutSignal output) 
    {
        sources.remove(output);
    }
    /**
    * Comprueba si se ha conectado un source. 
    *
    * Corresponde a una función de retorno booleano, que compara si el tamaño del ArrayList
    * es mayor a 0, lo que implicaría que hay al menos una fuente que se ha conectado.
    *
    * @return Devuelve True o False dependiendo si se cumple la condición.
    */
    public boolean hasConnectedSource() {
        return sources.size()>0;
      }
  
    /**
     * Imprime los encabezados de los archivos de salida.
     *
     * Permite estructurar el formato del archivo de salida.
     */    
   public void writeHeader(){
     out.print("Time\t\t");
     for (OutSignal w:sources) 
        out.print(w.getDescription()+"\t");
     out.println();
   }
   /**
    * LLeva el registro de los cambios de eventos medidos.
    *
    * Se lleva el registro en el tiempo de los cambios de los valores medidos de los  diferentes
    * sources implementadas para medir.
    *
    * @param time Corresponde al tiempo transcurrido en los registros de medición.
    */
   public void log(float time) {
      out.print(time+"\t\t");
      for (OutSignal w:sources) 
        out.print((w.getValue()?1:0)+"\t\t");
      out.println();
   }
   /**
    * Entrega el nombre e id del objeto Meter creado.
    *
    * Entrega el nombre e id del objeto Meter creado.
    *
    * @return retorna el nombre del objeto junto a su id.
    */
   public String getDescription() {
	    return getClass().getName().substring(1)+"_"+id;
	  }
}
