import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

import javax.swing.JOptionPane;

public class Inverter extends Gate implements Component{
  public Inverter(float delay, Simulator s) {
    super(delay,nextId++, s);
  }
  public Inverter(Simulator s) {
    this(Inverter.delay, s);
    
  }
  public void connectInput(OutSignal output){
    source = output;
    output.connectDrain(this);
  }
  public void disconnectInput(){
    if (source != null) {
      source.removeFromDrains(this);
      source = null;
     }
  }
  public void addSource(OutSignal output){
    source = output;
  }
  public void removeFromSource(OutSignal output){
    if (source == output)  source = null;
  }
  public boolean computeOutput(){
    if (source==null) return false; // open input corresponds to high 
    boolean in = source.getValue();
    return(!in);
  } 
  public boolean hasConnectedSource() {
    return source != null;
  } 
  public void setDelay(float new_delay){
	  Inverter.delay = new_delay;
  }
  public float getDelay(){
	  return Inverter.delay;
  }
  
  private OutSignal source=null;
  private static int nextId = 0;
  private static float delay = 1;
}