import java.awt.*;
import java.awt.geom.*;
import java.util.Scanner;

public class GWire extends Wire implements Drawable, GOutSignal, GInSignal {
   private Color color = Color.BLUE;
   private Line2D.Double line;
   private Rectangle2D.Double in;
   private Rectangle2D.Double out;
   private Rectangle2D.Double selectedEnd;
   private DigitalCircuit circuit;
   private static BasicStroke stroke;
   //private Path2D.Double _in;
   //private Path2D.Double _out; 
   //private Path2D.Double _line;
   
   public GWire(Point2D.Double pos, DigitalCircuit c){
      circuit = c;
     // AffineTransform at = AffineTransform.getTranslateInstance(pos.x, pos.y);
      in = new Rectangle2D.Double(pos.x, pos.y, 10,10);
      out = new Rectangle2D.Double(pos.x+80, pos.y, 10,10);
      line = new Line2D.Double(in.x + 5, in.y + 5, out.x + 5, out.y + 5);
      selectedEnd = null;
      stroke = new BasicStroke(2);
      
      //_line = (Path2D.Double) at.createTransformedShape(line);
      //_in = (Path2D.Double) at.createTransformedShape(in);
      //_out = (Path2D.Double) at.createTransformedShape(out);
      
   }
   public void draw (Graphics2D g){
      g.setColor(color);
      g.setStroke(stroke);
      g.draw(line);
      if (hasConnectedSource())
        g.fill(in);
      else
        g.draw(in);
      g.setColor(Color.GREEN);
      g.draw(out);
   }
   public boolean contains (Point p){
     boolean result=false;
     if (result = in.contains(p))
        selectedEnd=in;
     else if (result = out.contains(p))
             selectedEnd= out;
          else
             selectedEnd = null;
     return result;
   }
   public Shape getGOutput() {
     return out;
   }
   public Shape getGInput() {
     return in;
   }
   public void dragIn(int dx, int dy) {
      if (selectedEnd==null) return;
      selectedEnd.x+=dx;
      selectedEnd.y+=dy;
      line.setLine(in.x + 5, in.y + 5, out.x + 5, out.y + 5);
     // disconnectInput();
	 // disconnectAllOutput();
   }
   public void flip() {
   }
   public void setSelected() {
     color = Color.RED;
   }
   public void setReleased() {
     color = Color.BLUE;
   }
   public void tryToConnect(){
      if (selectedEnd == in) {
         GOutSignal source = circuit.findSource(in);
         if (source !=null) {
            source.connectOutput(this);
            Rectangle2D bound = source.getGOutput().getBounds();
            in.x = bound.getX();
            in.y = bound.getY();
         } else
            disconnectInput();
      } else if (selectedEnd == out) { 
         GInSignal drain = circuit.findDrain(out);
         if (drain !=null) {
            drain.connectInput(this);
            Rectangle2D bound = drain.getGInput().getBounds();
            out.x = bound.getX();
            out.y = bound.getY();
         } else
            disconnectAllOutput();
      }
      line.setLine(in.x + 5, in.y + 5, out.x + 5, out.y + 5);
   }
   public void DELETE()
   {
	   disconnectInput();
	   disconnectAllOutput();
	   line.setLine(-1000, -1000, -1000, -1000);
	   in.setRect(-1000, -1000, -1000, -1000);
	   out.setRect(-1000, -1000, -1000, -1000);
   }
}
