import java.awt.*;
import java.awt.geom.*;
import java.io.File;
import java.util.Scanner;

public class GSource extends Source implements Drawable, GOutSignal {
   private static final Path2D.Double polyline = 
                      new Path2D.Double(Path2D.WIND_EVEN_ODD,5);
   private static final Rectangle2D.Double output= new Rectangle2D.Double(55,5,10,10);
   static {  // static initialization block. 
      polyline.moveTo (0, 10);
      polyline.curveTo(0,35, 40,35, 40,10);
      polyline.lineTo(55,10);
      polyline.lineTo(40,10);
      polyline.curveTo(40,-15, 0,-15, 0,10);
   }
   private Color color = Color.BLUE;
   private Path2D.Double shape;
   private Path2D.Double out;
   private static BasicStroke stroke;
   
   public GSource(Point2D.Double pos, File in, Simulator sim){
      super(in, sim);
      AffineTransform at = AffineTransform.getTranslateInstance(pos.x, pos.y);
      shape = (Path2D.Double) at.createTransformedShape(polyline);
      out = (Path2D.Double) at.createTransformedShape(output);
      stroke = new BasicStroke(2);
   }
   public void draw (Graphics2D g){
      g.setColor(color);
      g.setStroke(stroke);
      g.draw(shape);
      g.draw(out);
      Rectangle2D position = shape.getBounds2D();
      double x = position.getX()+position.getWidth()/2;
      double y = position.getY()+position.getWidth()/2;
      g.drawString(getDescription(),(int)x -25, (int)y + 30);
   }
   public boolean contains (Point p){
     return shape.contains(p);
   }
   public void dragIn(int dx, int dy) {
      AffineTransform at = AffineTransform.getTranslateInstance(dx, dy);
      shape.transform(at);
      out.transform(at);
      disconnectAllOutput();
      
   }
   public void flip() {
     AffineTransform af = new AffineTransform();   
     Rectangle2D box = shape.getBounds2D(); 
     double x = box.getX()+box.getWidth()/2;

	  // Note: the transformations get applied IN REVERSE ORDER!
	  af.translate(x,0);
	  af.scale(-1, 1);
	  af.translate(-x, 0);          
	  shape.transform(af);
     out.transform(af);
   }
   public void setSelected() {
     color = Color.RED;
   }
   public void setReleased(){
     color = Color.BLUE;
   }
   public Shape getGOutput() {
     return out;
   }
   public void DELETE()
   {
	   disconnectAllOutput();
	   AffineTransform er = new AffineTransform();   
	   Rectangle2D box = shape.getBounds2D(); 
	   er.translate(-1000,-1000);
	   shape.transform(er);
	   out.transform(er);
   }
}
