import java.awt.*;
import java.awt.geom.*;

class GOrGate extends OrGate implements Drawable, GOutSignal, GInSignal {
   private static final Path2D.Double polyline = 
                      new Path2D.Double(Path2D.WIND_EVEN_ODD,10);
   private static final Rectangle2D.Double input= new Rectangle2D.Double(-5,15,10,10);
   private static final Rectangle2D.Double output= new Rectangle2D.Double(95,15,10,10);
   static {  // static initialization block. 
      polyline.moveTo (20, 0);
      polyline.curveTo(30,0, 30,40 ,20,40);
      polyline.moveTo(25,20);
      polyline.lineTo(0,20);
      polyline.lineTo(25,20);
      polyline.moveTo(20,40);
      polyline.curveTo(85,40, 85,0, 20,0);
      polyline.moveTo(70,20);
      polyline.lineTo(100,20);
      polyline.lineTo(80,20);
   }
   private Color color = Color.BLUE;
   private Path2D.Double shape;
   private Path2D.Double in;
   private Path2D.Double out;
   private final BasicStroke stroke;
   
   public GOrGate(Point2D.Double pos, Simulator sim){
      super(sim);
      AffineTransform at = AffineTransform.getTranslateInstance(pos.x, pos.y);
      shape = (Path2D.Double) at.createTransformedShape(polyline);
      in = (Path2D.Double) at.createTransformedShape(input);
      out = (Path2D.Double) at.createTransformedShape(output);
      stroke = new BasicStroke(2);
   }
   public void draw (Graphics2D g){
      g.setColor(color);
      g.setStroke(stroke);
      g.draw(shape);
      Rectangle2D position = shape.getBounds2D();
      double x = position.getX()+position.getWidth()/2;
      double y = position.getY()+position.getWidth()/2;
      g.drawString(getDescription(),(int)x -32, (int)y + 10);
      if (hasConnectedSource())
        g.fill(in);
      else
        g.draw(in);
      g.draw(out);
   }
   public boolean contains (Point p){
     return shape.contains(p);
   }
   
   public void dragIn(int dx, int dy) {
      AffineTransform at = AffineTransform.getTranslateInstance(dx, dy);
      shape.transform(at);
      in.transform(at);
      out.transform(at);
      disconnectInput();
      disconnectAllOutput();
   }
   public void flip() {
     AffineTransform af = new AffineTransform();   
     Rectangle2D box = shape.getBounds2D(); 
     double x = box.getX()+box.getWidth()/2;

	  // Note: the transformations get applied IN REVERSE ORDER!
	  af.translate(x,0);
	  af.scale(-1, 1);
	  af.translate(-x, 0);          
	  shape.transform(af);
     in.transform(af);
     out.transform(af);
   }
   public void setSelected() {
     color = Color.RED;
   }
   public void setReleased(){
     color = Color.BLUE;
   }
   public Shape getGOutput() {
     return out;
   }
   public Shape getGInput() {
     return in;
   }
   public void DELETE()
   {
	   disconnectInput();
	   disconnectAllOutput();
	   AffineTransform er = new AffineTransform();   
	   Rectangle2D box = shape.getBounds2D(); 
	   er.translate(-1000,-1000);
	   shape.transform(er);
	   in.transform(er);
	   out.transform(er);
   }
}
