/**
 * @author      Oscar Silva <oscar.silvam@alumnos.usm.cl>
 * @version     1.7                 (current version number of program)
 * @since       2013-05-15          (the version of the package this class was first added to)
 */
import java.awt.*;
import java.awt.geom.*;
import java.io.File;
import java.io.PrintStream;

public class GMeter extends Meter implements Drawable ,GInSignal{
	/**
	 * Define el objeto polyline de la clase Path2D.Double.
	 */
   private static final Path2D.Double polyline = 
                      new Path2D.Double(Path2D.WIND_EVEN_ODD,5);
   /**
    * Define el objeto input de la clase Rectangle2D.Double.
    */
   private static final Rectangle2D.Double input= new Rectangle2D.Double(0,5,10,10);
   static {  // static initialization block. 
      polyline.moveTo(25,-3);
      polyline.lineTo(25,10);
      polyline.lineTo(10,10);
      polyline.lineTo(25,10);
      polyline.lineTo(25,23);
      polyline.lineTo(65,23);
      polyline.lineTo(65,-3);
      polyline.lineTo(25,-3);
      
   }
   /**
    * Define el objeto color de la clase Color y lo setea en azul.
    */
   private Color color = Color.BLUE;
   /**
    * Define el objeto shape de la clase Path2D.Double.
    */
   private Path2D.Double shape;
   /**
    * Define el objeto in de la clase Path2D.Double.
    */
   private Path2D.Double in;
   /**
    * Define el objeto stroke de la clase BasicStroke.
    */
   private static BasicStroke stroke;
   /**
    * Crea el objeto Meter de forma Grafica.                    	    
    * <p>
    * Crea el objeto Meter de forma grafica, este es el constructor		
    * de la clase.
    * @param  pos entrega el punto donde sera creado el objeto GMeter.         				   		
    * @param  os entrega el archivo donde seran guardados los datos de la simulacion.
    */
   public GMeter(Point2D.Double pos, File os){
      super(os);
      AffineTransform at = AffineTransform.getTranslateInstance(pos.x, pos.y);
      shape = (Path2D.Double) at.createTransformedShape(polyline);
      in = (Path2D.Double) at.createTransformedShape(input);
      stroke = new BasicStroke(2);
   }
   /**
    * Dibuja el objeto inicial junto a sus entradas correspondientes. 
    * <p>
    * Dibuja el objeto visual inicial que representa al objeto Meter  
    * con el cual el usuario puede interactuar.
    * 
    *
    * @param  g entrega el objeto grafico correspondiente al objeto Meter.                               
    * 
    */
   public void draw (Graphics2D g){
      g.setColor(color);
      g.setStroke(stroke);
      g.draw(shape);
      Rectangle2D position = shape.getBounds2D();
      double x = position.getX()+position.getWidth()/2;
      double y = position.getY()+position.getWidth()/2;
      g.drawString(getDescription(),(int)x -20, (int)y + 15);
      if (hasConnectedSource())
          g.fill(in);
        else
          g.draw(in);
   }
   /**
    * Indica si un punto pertenece al objeto grafico de Meter.                           
    * <p>
    * Indica si un punto p pertenece al objeto grafico de objeto
    * Meter en la ventana de la aplicacion.    
    *
    * @param  p corresponde al punto del objeto grafico de Meter del cual se pregunta.          
    * @return Retorna verdadero si el punto corresponde al objeto grafico y falso si no corresponde.
    */
   public boolean contains (Point p){
     return shape.contains(p);
   }
   /**
    * Permite mover el objeto grafico de Meter.              
    * <p>
    * Permite mover el objeto grafico de Meter a cualquier  
    * lugar dentro de la ventana de la aplicacion.
    * 
    *  
    * @param dx corresponde a la cordenada x a donde se esta moviendo el objeto grafico. 
    * @param dy corresponde a la cordenada y a donde se esta moviendo el objeto grafico.
    */
   public void dragIn(int dx, int dy) {
      AffineTransform at = AffineTransform.getTranslateInstance(dx, dy);
      shape.transform(at);
      in.transform(at);
      disconnectInput();
	  
   }
   /**
    * Permite rotar el objeto grafico de Meter.                
    * <p>
    * Permite rotar el objeto grafico de Meter con la ayuda    
    * del scroll del mouse.
    *     
    */
   public void flip() {
     AffineTransform af = new AffineTransform();   
     Rectangle2D box = shape.getBounds2D(); 
     double x = box.getX()+box.getWidth()/2;

	  // Note: the transformations get applied IN REVERSE ORDER!
	  af.translate(x,0);
	  af.scale(-1, 1);
	  af.translate(-x, 0);          
	  shape.transform(af);
     in.transform(af);
   }
   /**
    * Setea el color del objeto Meter en Rojo.               
    * <p>
    * Setea el color del objeto grafico de meter en Rojo.       
    */
   public void setSelected() {
     color = Color.RED;
   }
   /**
    * Setea el color del objeto Meter en Azul.               
    * <p>
    * Setea el color del objeto grafico de meter en Azul.       
    */
   public void setReleased(){
     color = Color.BLUE;
   }   
   /**
    * Retorna el objeto creado para la entrada de Meter.  
    * <p>
    * Retorna el objeto grafico creado para simbolizar    
    * la entrada de Meter.    
    *
    *           
    * @return objeto grafico relcionado con la entrada del objeto grafico.
    */
   public Shape getGInput() {
     return in;
   }
   /**
    * Elimina el objeto grafico de Meter.                   
    * <p>
    * Elimina el objeto grafico de Meter sacandolo de la    
    * ventana de la aplicacion.    
    *      
    */
   public void DELETE()
   {
	   disconnectInput();
	   AffineTransform er = new AffineTransform();   
	   Rectangle2D box = shape.getBounds2D(); 
	   er.translate(-1000,-1000);
	   shape.transform(er);
	   in.transform(er);
	   
   }
}
