import java.awt.event.*;
import javax.swing.JMenuItem;
import javax.swing.*;
import javax.swing.filechooser.*;
import java.io.*;
import java.util.Scanner;

public class EditMenuListener implements ActionListener {
  private DigitalCircuit circuit;
  public EditMenuListener (DigitalCircuit c) {
     circuit = c;
  }
  public void actionPerformed(ActionEvent e) {
      JMenuItem menuItem = (JMenuItem)(e.getSource());
      String text = menuItem.getText();
      if (text.equals("Inverter")) 
          circuit.addInverter();
      if (text.equals("Nand gate")) 
          circuit.addNand();
      if (text.equals("Nor gate")) 
          circuit.addNor();
      
      if (text.equals("Or gate")) 
         circuit.addOrGate();
      if (text.equals("Wire")) 
         circuit.addWire();
         
      if (text.equals("Source")) {    		  
        Scanner data=null;
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(".txt data files", "txt");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);        
    	if(returnVal == JFileChooser.APPROVE_OPTION) {
            try {
              data= new Scanner(chooser.getSelectedFile());
            } catch(FileNotFoundException ef) {
              return;
            }
            //circuit.addSource(data);
            circuit.addSource(chooser.getSelectedFile());
          }
        
      }
      if (text.equals("Meter")) 
      {
            PrintStream os = null;
            JFileChooser savefile = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(".txt data files", "txt");
            savefile.setFileFilter(filter);
            
            int returnVal = savefile.showSaveDialog(null);
            if(returnVal == JFileChooser.APPROVE_OPTION) {
              try {
                os= new PrintStream(savefile.getSelectedFile());               
              } catch(FileNotFoundException ef) {
                return;
              }
        circuit.addMeter(savefile.getSelectedFile());
     }
   }
      
}
  
}
