import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;

public class DigitalCircuitLabPanel extends JPanel {
  private DigitalCircuit circuit;
  private MouseListener mListener;
  

  public DigitalCircuitLabPanel(DigitalCircuit c){
    circuit = c;
    mListener = new MouseListener(circuit, this);   
    addMouseMotionListener(mListener);
    addMouseListener(mListener);
    addMouseWheelListener(mListener);
    
  }
  public void paintComponent(Graphics g) {
    super.paintComponent(g); // it paints the background
    Graphics2D g2 = (Graphics2D) g;
    circuit.paintComponent(g2);
  }
   public void enableMouseListener(){
      addMouseMotionListener(mListener);
      addMouseListener(mListener);         
      addMouseWheelListener(mListener);
   }
   public void desableMouseListener(){
      removeMouseMotionListener(mListener);
      removeMouseListener(mListener);
      removeMouseWheelListener(mListener);
   }

}
