import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.*;
import java.awt.event.*;
import java.awt.Graphics2D;
import java.awt.event.KeyListener;




public class DigitalCircuitLab {
	public static void main(String[] args) {
		DigitalCircuitFrame circuitFrame = new DigitalCircuitFrame();
		circuitFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		circuitFrame.setVisible(true);
	}
}

class DigitalCircuitFrame extends JFrame implements KeyListener{
   public static final int DEFAULT_WIDTH=640;
   public static final int DEFAULT_HEIGHT=480;
   public static final DigitalCircuit circuit = new DigitalCircuit();
   public static final JPanel labpanel = new DigitalCircuitLabPanel(circuit);
   private Drawable currentComponent;
   private Component currentGate;

	public DigitalCircuitFrame() {
		setTitle("My Digital Circuit Laboratory");
		setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
		//DigitalCircuit circuit = new DigitalCircuit();
		//JPanel labPanel = new DigitalCircuitLabPanel(circuit);
		add(labpanel);  // it is equivalent to getContentPane().add(...);
		circuit.setPanel(labpanel);   // to repaint view when model changes
		JMenuBar menuBar = createLabMenuBar(circuit);
		setJMenuBar(menuBar);

		addKeyListener(this);
	}

 	public void keyPressed(KeyEvent event)
      {  
         int keyCode = event.getKeyCode();
 		 if (keyCode == KeyEvent.VK_D) {
			if (Global.currentComponent!=null){
				
				Global.currentComponent.DELETE();
				labpanel.repaint();
				}

		}
 		if (keyCode == KeyEvent.VK_R) {
 			
			if (Global.currentComponent instanceof Gate){
				Global.currentGate = (Component)Global.currentComponent;
	 			boolean test = true;
	 			float testeo = Global.currentGate.getDelay();				
				try {
	                 String d = JOptionPane.showInputDialog("Ingrese el retardo de la compuerta seleccionada:");
	                 testeo = Float.parseFloat(d);
	                 if(testeo < 0){
	                     JOptionPane.showMessageDialog(null, "Error al introducir el retardo.");
					     testeo = Global.currentGate.getDelay();
	                 }
				 }catch (Exception error) {
					 test = false;
					 error.printStackTrace();
					 JOptionPane.showMessageDialog(null, "Error al introducir el retardo.");
				 }
				if(test){
				Global.currentGate.setDelay(testeo);
				System.out.println(Global.currentGate.getDelay());
				}
			}else{
				
				JOptionPane.showMessageDialog(null, "Esta opción es valida solo para compuertas.");
			}
				
			 
		}
      }

      public void keyReleased(KeyEvent event){}

      public void keyTyped(KeyEvent event){}


	private JMenuBar createLabMenuBar(DigitalCircuit circuit) {
		EditMenuListener editListener = new EditMenuListener(circuit);
		SimulateMenuListener simulateListener = new SimulateMenuListener(circuit);

		JMenuBar mb = new JMenuBar();

		JMenu menu = new JMenu ("Edit");
		mb.add(menu);
		JMenu subMenu = new JMenu("Insert");  
		menu.add(subMenu);

		JMenuItem menuItem = new JMenuItem("Inverter", new ImageIcon("./images/INVERTER.jpg"));
		menuItem.addActionListener(editListener);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Or gate", new ImageIcon("./images/OR.jpg"));

		menuItem.addActionListener(editListener);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Nand gate", new ImageIcon("./images/NAND.jpg"));

		menuItem.addActionListener(editListener);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Nor gate", new ImageIcon("./images/NOR.jpg"));

		menuItem.addActionListener(editListener);
		subMenu.add(menuItem);		
		menuItem = new JMenuItem("Wire", new ImageIcon("./images/WIRE.jpg"));
		menuItem.addActionListener(editListener);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Source", new ImageIcon("./images/Source.jpg"));
		menuItem.addActionListener(editListener);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Meter", new ImageIcon("./images/METER.jpg"));
		menuItem.addActionListener(editListener);
		subMenu.add(menuItem);

		menu = new JMenu("Simulate");
		mb.add(menu);
		menuItem = new JMenuItem("Start", new ImageIcon("./images/SIMULATE.jpg"));
		menuItem.addActionListener(simulateListener);
		menu.add(menuItem);
		return mb;          
	}   

}

 class MouseListener extends MouseAdapter {
   private DigitalCircuit circuit;
   private Drawable currentComponent;
   
   private JPanel panel;
   private Point last, current;
 MouseListener (DigitalCircuit c, JPanel p){
      circuit = c;
      panel = p;
      last = current = null;
   } 
   public void mouseMoved(MouseEvent e) {
      last = e.getPoint();
      Drawable newComponent = circuit.find(last);
      
      if (newComponent == Global.currentComponent) return;
      if (Global.currentComponent != null) {
         Global.currentComponent.setReleased();
         Global.currentComponent = null;
      }
      if (newComponent != null) {
         Global.currentComponent = newComponent;
         Global.currentComponent.setSelected();
      }
      panel.repaint();
   }
	
	public Drawable getComponent(){
	Drawable newComponent = circuit.find(last);
	return newComponent;

	}

   public void mouseDragged(MouseEvent e) {
      if (Global.currentComponent == null) return;
      current = e.getPoint();
      Global.currentComponent.dragIn(current.x-last.x, current.y-last.y);
      last=current;
      panel.repaint();
   }
   public void mouseWheelMoved(MouseWheelEvent e) {
      if (Global.currentComponent == null) return;
      Global.currentComponent.flip();
      panel.repaint();
   }
   public void mouseReleased(MouseEvent e) {
      if (Global.currentComponent instanceof GWire) {
         GWire w = (GWire)Global.currentComponent;
         w.setReleased();
         w.tryToConnect();         
         panel.repaint();
      }
   }
}
