import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.io.File;
import java.io.PrintStream;

public class DigitalCircuit {
  private JPanel panel;
  private Simulator simulator;
  private ArrayList<Drawable> components;
  
  public DigitalCircuit(){
    simulator = new Simulator();
    components = new ArrayList<Drawable>();
  }
  public void setPanel(JPanel p){
    panel = p;
  }
  public void simulate(){	  ////////////// 
	  	
		
		simulator.resetSimulator();	
		for(Drawable d: components){
			/*if(d instanceof Component)
				((Gate) d).resetGate();*/
			if(d instanceof Source)
				((Source) d).loadSource();
			if(d instanceof Meter)
				((Meter) d).clearMeter();			
		}	
		simulator.simulate();///esto ya estaba
	    
	
  }
  public Drawable find(Point p) {
     for (Drawable component : components)
       if (component.contains(p))
          return component;
     return null;
  }

  public GOutSignal findSource(Rectangle2D rec) {
     for (Drawable component : components) 
       if (component instanceof GOutSignal) {
          GOutSignal source = (GOutSignal)component;
          if (source.getGOutput().intersects(rec))
            return source;
       }
     return null;
  }
  public GInSignal findDrain(Rectangle2D rec) {
     for (Drawable component : components) 
       if (component instanceof GInSignal) {
          GInSignal drain = (GInSignal)component;
          if (drain.getGInput().intersects(rec))
            return drain;
       }
     return null;
  }

  public void paintComponent(Graphics2D g) {
    for (Drawable c: components) 
      c.draw(g);
  }
  
  
  public void addInverter() {
    components.add(new GInverter(new Point2D.Double(20f, 20f), simulator));
    panel.repaint();
  }
  public void addNand() {
    components.add(new GNandGate(new Point2D.Double(20f, 20f), simulator));
    panel.repaint();
  }
  public void addNor() {
    components.add(new GNorGate(new Point2D.Double(20f, 20f), simulator));
    panel.repaint();
  }
  public void addOrGate() {
    components.add(new GOrGate(new Point2D.Double(20f, 20f), simulator));
    panel.repaint();
  }
  public void addWire() {
    components.add(new GWire(new Point2D.Double(20f, 20f), this));
    panel.repaint();
  }
  public void addSource(File data) {
    components.add(new GSource(new Point2D.Double(20f, 20f), data, simulator));
    panel.repaint();
  }
  public void addMeter(File os) {
	GMeter gmeter = new GMeter(new Point2D.Double(20f, 20f), os);
    components.add(gmeter);
    simulator.addMeter(gmeter);
    panel.repaint();
  }
}
