public class ChangeEvent implements Comparable{
  private UpdateListener listener;
  private float time;
  private boolean value;
  
  public ChangeEvent (UpdateListener l, boolean val, float t) {
    listener = l;
    value = val;
    time = t;
  }
  
  public int compareTo(Object o) {
     ChangeEvent e = (ChangeEvent) o;
     return (int)(time - e.time);
  }
  
  public void performUpdate (Simulator s) {
    listener.updateOutputValue(value);
    System.out.println(s.getTime()+"\t"+listener.getClass().getSimpleName()+"\t"+value);
  }
  public void notifyUpdate () {
    listener.propagateOutputValue();
  }
  public float getTime() {
    return time;
  }
}