import java.awt.event.*;
import javax.swing.JOptionPane;
import javax.swing.JMenuItem;
import java.awt.*;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.*;

public class WorldControlMenuListener extends JFrame implements ActionListener {
	private MyWorld  world;
	//private GraphsPanel graphPanel;
	//private JSplitPane splitPane;
	private PhysicsLabPanel labPanel;
	private Container contentPane;
	//private PhysicsLab frame;
	public WorldControlMenuListener (MyWorld  w, /*GraphsPanel gp,*/ PhysicsLabPanel lp, /*JSplitPane jp,*/ Container cp/*, PhysicsLab fr*/){
	      world = w;
	      //graphPanel = gp;
	      labPanel = lp;
	      //splitPane = jp;
	      contentPane = cp;
	      //frame = fr;
	}
	public void actionPerformed(ActionEvent e) {
		String data;
		JMenuItem menuItem = (JMenuItem)(e.getSource());
		String text = menuItem.getText();
		if (text.equals("Start")) world.start();
		if (text.equals("Stop"))    world.stop();
		if (text.equals("Gravity")) {
			try {
				data = JOptionPane.showInputDialog("Enter Gravity [m/s^2]");
				world.setGravity(new Vector2D(0,-Float.parseFloat(data)));
			} catch ( NumberFormatException ex) {
				world.setGravity(new Vector2D(0,0));
			}
		}
		if (text.equals("Viscosity")) { 
			try {
				data = JOptionPane.showInputDialog("Enter Viscosity [kg/(sm)]");
				world.setViscosity(Float.parseFloat(data));
			} catch ( NumberFormatException ex) {
				world.setViscosity(0f);
			}
		}
		if (text.equals("Delta time")){ 
			try {
				data = JOptionPane.showInputDialog("Enter delta t [s]");
				world.setDelta_t(Float.parseFloat(data));
			} catch ( NumberFormatException ex) {
				world.setDelta_t(MyWorld.DEFAUL_DELTA);
			}
		}
		if (text.equals("Graphics Refresh time")){ 
			try {
				data = JOptionPane.showInputDialog("Enter refresh time [s]");
				world.setRefreshPeriod(Float.parseFloat(data));
			} catch ( NumberFormatException ex) {
				world.setRefreshPeriod(MyWorld.DEAFAUL_REFRESH);
			}
		}
	}
}
