public class Wall extends PhysicsElement {
	public static final int SIDEWAYS=0;
	public static final int STRAIGHT=1;
	private static Vector2D origin = new Vector2D(0,0); 
	private static int id=0;
	protected Vector2D anchor;
	protected float length;
	protected final int orientation;
	private static float mass=Float.MAX_VALUE/1000.0f;

	private Wall() {   // nobody can create a block without state
		super(id++);
		orientation=SIDEWAYS;
	}
	public Wall(Vector2D initPoint, int orient, float leng, MyWorld world){
		super(id++);
		anchor = initPoint;
		orientation = orient;
		length=leng;
		world.addElement(this);
	}
        public float getEC(){
            return 0;
        }
	public float getEP(){
            return 0;
        }
	public Vector2D getPosition() {
		return anchor;
	}
	public double getX() {
		return anchor.getX();
	}
	public double getY() {
		return anchor.getY();
	}
	public void setPosition(double x, double y){
		anchor.set(x,y);
	}
	public void setLength(float l){
		length = l;
	}
	public float getLength(){
		return length;
	}
	public float getMass() {
		return mass;
	}
	public float getRadius() {
		return 0;
	}
        public boolean getOrientation(){
            return (orientation==SIDEWAYS);
        }
	public Vector2D getSpeed() {
		return origin;
	}
	public boolean collide(PhysicsElement pe) {
		return false;   // walls do not collide, others collide with them.
	}
	public void computeNextState(double deltaT, MyWorld w) {
	}
	public void updateState() {	
	}
	public Vector2D getVectorBetweenCenters(PhysicsElement pe) {
		if (pe instanceof Ball){
			Vector2D center=pe.getPosition();  // it is a ball
			switch (orientation){
			case SIDEWAYS:
				if (center.getX() < anchor.getX())
					return anchor.minus(center);
				else if (center.getX() > anchor.getX()+length)
					return anchor.plus(new Vector2D(length, 0)).minus(center);
				else
					return new Vector2D(0,anchor.getY()-center.getY());
			case STRAIGHT: 
				if (center.getY() < anchor.getY())
					return anchor.minus(center);
				else if (center.getY() > anchor.getY()+length)
					return anchor.plus(new Vector2D(0,length)).minus(center);
				else				
					return new Vector2D(anchor.getX()-center.getX(), 0);
			}
		}
		return null;
	}
	public String getState() {
		return "Wall "+getPosition()+"  ";
	}
}
