/**
 *Clase Vector2D vectores
 *Contiene las operaciones mas usadas en vectores
 */

public class Vector2D {
	private double x, y;  // we will use cartesian coordinates
	/**
	 *Constructor sin argumentos de la Clase 2D	
	 */
	public Vector2D () {
		x = y = 0;
	}
	/**
	 *Constructor de la Clase 2D
	 * @param x 	coordenada x
	 * @param y	coordenada y	
	 */
	public Vector2D (double x, double y) {
		this.x = x;
		this.y = y;
	}
	/**
	* Metodo que retorna coordenada x
	*/
	public double getX(){
		return x;
	}
	/**
	* Metodo que retorna coordenada y
	*/
	public double getY(){
		return y;
	}
	/**
	* Metodo que cambia posicion del vector
	* @param x 	nueva coordenada x
	* @param y	nueva coordenada y
	*/
	public void set(double x, double y){ // to set a new position
		this.x=x;
		this.y=y;
	}
	/**
	* Metodo aumenta tamaño vector 
	* @param v	vector
	*/
	public Vector2D plus(Vector2D v) {
		if (v==null) return new Vector2D(x,y);
		return new Vector2D(x+v.x, y+v.y);
	}
	/**
	* Metodo multiplica por un escalar 
	* @param scalar	escalar
	*/
	public Vector2D times(double scalar) {
		return new Vector2D(x*scalar, y*scalar);
	}
	/**
	* Metodo disminuye tamaño vector 
	* @param v	vector
	*/
	public Vector2D minus(Vector2D v) {
		if (v==null) return new Vector2D(x,y);
		return new Vector2D(x-v.x, y-v.y);
	}
	/**
	* Metodo multiplicacion de vectores
	* @param v	vector
	*/
	public double dotProduct(Vector2D v) {
		return x*v.x + y*v.y;
	}
	/**
	* Metodo obtener proyeccion
	* @param v	vector
	*/
	public Vector2D getProjectionOn(Vector2D v){
		double newModule = x*v.x + y*v.y;
		return v.times(newModule/(v.x*v.x + v.y*v.y));
	} 
	/**
	* Metodo obtener modulo vector 
	*@return modulo
	*/
	public double module() {
		return Math.sqrt(x*x + y*y);
	}
	/**
	* Metodo disminuye tamaño vector 
	*@return modulo
	*/
	public double moduleSquared() {
		return x*x + y*y;
	}
	/**
	* Metodo vector unitario 
	*@return vector unitario
	*/
	public Vector2D unitary() {
		return times(1/module());
	}
	/**
	* Metodo obtener descripcion de vector
	*@return "(x,y)"
	*/
	public static String getDescription() {
		return "(x,y)";
	}
	/**
	* Metodo obtener descripcion de vector en string
	*@return string con valor de vector
	*/
	public String toString() {
		return "Vector "+x+","+y;
	}
}
