import javax.swing.JFrame;
import javax.swing.*;
import javax.swing.JSplitPane;
import java.awt.*;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

class PhysicsLabFrame extends JFrame {

	public PhysicsLabFrame() { 
		int i;
		Properties pro = new Properties();
		String stringAux = new String();
		int sideNum;
		int ballNum;
      		try{
      			FileInputStream fichero = new FileInputStream("PhysicsLab.ini");
      			pro.load(fichero);
      			}catch(IOException e){
			    	  	System.err.println("Configuration file PhysicsLab.ini doesn't exist.");
			    	  	}
		String title = new String(pro.getProperty("Title","Small Physics Laboratory"));
		if(title.equals("")) title = new String("Small Physics Laboratory");
		setTitle(title);
		stringAux = new String(pro.getProperty("sideNum", "0"));
		if(stringAux.equals("")) sideNum =  0;
		else sideNum = Integer.parseInt(stringAux);
		stringAux = new String(pro.getProperty("ballNum", "0"));
		if(stringAux.equals("")) ballNum =  0;
		else ballNum = Integer.parseInt(stringAux);
		
		String totalWall = new String();
		for(i=1; i<=sideNum;i++){
			
			if(i==1)
			{	
				stringAux = pro.getProperty("wall."+i,"1.2;0.2;SIDEWAYS;2.8");
				if(stringAux.equals("")) stringAux = new String ("1.2;0.2;SIDEWAYS;2.8");
				totalWall = totalWall + stringAux;
			}
			else
			{
				stringAux = pro.getProperty("wall."+i,(1.2+i)+";0.2;SIDEWAYS;2.8");
				if(stringAux.equals("")) stringAux = new String ((1.2+i)+";0.2;SIDEWAYS;2.8");
				totalWall = totalWall +";"+ stringAux;
			}
		}
		String totalBall = new String();
		for(i=1; i<=ballNum;i++){
			if(i==1)
			{
				stringAux = pro.getProperty("ball."+i,"250;0.2;1.5;0.6;10;6;red");
				if(stringAux.equals("")) stringAux = new String ("250;0.2;1.5;0.6;10;6;red");
				totalBall = totalBall + stringAux;
			}
			else
			{
				stringAux = pro.getProperty("ball."+i,"250;0.2;"+(i+1.5)+";0.6;10;6;red");
				if(stringAux.equals("")) stringAux = new String ("250;0.2;"+(i+1.5)+";0.6;10;6;red");
				totalBall = totalBall +";"+ stringAux;
			}
		}
		double refreshTime;
		stringAux = new String(pro.getProperty("refreshTime","0.03"));
		if(stringAux.equals("")) refreshTime = 0.03;
		else refreshTime = Double.valueOf(stringAux).doubleValue();
		double deltaTime;
		stringAux = new String(pro.getProperty("deltaTime","0.001"));
		if(stringAux.equals("")) deltaTime = 0.001;
		else deltaTime = Double.valueOf(stringAux).doubleValue();
		float viscosity;
		stringAux = new String(pro.getProperty("viscosity","0.0"));
		if(stringAux.equals("")) viscosity = (float)0.0;
		else viscosity = Float.valueOf(stringAux).floatValue();
		float gravity;
		stringAux = new String(pro.getProperty("gravity","9.8"));
		if(stringAux.equals("")) gravity = (float)9.8;
		else gravity = Float.valueOf(stringAux).floatValue();

		setSize(MyWorld.WIDTH, MyWorld.HEIGHT+50);
		setResizable(true);
		MyWorld world = new MyWorld(0.03 , deltaTime, viscosity, gravity);
		PhysicsLabPanel labPanel = new PhysicsLabPanel(world);
		add(labPanel);
		GraphsPanel graphPanel = new GraphsPanel();
		stringAux = new String(pro.getProperty("plotWindowTime"));
		if(stringAux.equals("")) stringAux = new String("30");
		graphPanel.setMaxTime(Double.valueOf(stringAux)
				.doubleValue());
      		graphPanel.setAlignmentY(LEFT_ALIGNMENT);
      		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, labPanel, graphPanel);
      		labPanel.setMinimumSize(new Dimension(700,500));
      		graphPanel.setMinimumSize(new Dimension(500,500));
      		
      		splitPane.setDividerLocation(this.getWidth());		
      		
      		Container contentPane = getContentPane();
      		contentPane.add(splitPane);		
		
      		world.setPanel(labPanel);		
		world.setPanelGraphs(graphPanel);
		
		ElementMenuListener cListener = new ElementMenuListener(world, totalWall, sideNum, totalBall, ballNum);
		WorldControlMenuListener wcListener = new WorldControlMenuListener(
				world,/* graphPanel, */labPanel,/* splitPane, */contentPane/*, this*/);
        EnergyPlotMenuListener epListener = new EnergyPlotMenuListener(world,
				graphPanel, labPanel, splitPane, contentPane, this);
        RightClickMenuListener rc = new RightClickMenuListener(world);
        world.setBRC(rc);
		JMenuBar menuBar = createLabMenuBar(cListener, wcListener, epListener);
                menuBar.add(world.getBRCitem());
		setJMenuBar(menuBar);
	}

	private JMenuBar createLabMenuBar(ElementMenuListener cl, WorldControlMenuListener wl, EnergyPlotMenuListener ep) {
		JMenuBar mb = new JMenuBar();

		JMenu menu = new JMenu ("Element");
		mb.add(menu);
                
		JMenuItem menuItem = new JMenuItem("New Scenario");  
		menu.add(menuItem);
		menuItem.addActionListener(cl);
                
		JMenu subMenu = new JMenu("Insert");  
		menu.add(subMenu);

		menuItem = new JMenuItem("Ball");
		menuItem.addActionListener(cl);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Wall Sideways");
		menuItem.addActionListener(cl);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Wall Straight");
		menuItem.addActionListener(cl);
		subMenu.add(menuItem);
		
		menuItem = new JMenuItem("Scenario");
		menuItem.addActionListener(cl);
		subMenu.add(menuItem);
                
                menuItem = new JMenuItem("Delete");
                menuItem.addActionListener(cl);
                menu.add(menuItem);

		menu = new JMenu("MyWorld");
		mb.add(menu);
		menuItem = new JMenuItem("Start");
		menuItem.addActionListener(wl);
		menu.add(menuItem);
		menuItem = new JMenuItem("Stop");
		menuItem.addActionListener(wl);
		menu.add(menuItem);
		menuItem = new JMenuItem("Gravity");
		menuItem.addActionListener(wl);
		menu.add(menuItem);
		menuItem = new JMenuItem("Viscosity");
		menuItem.addActionListener(wl);
		menu.add(menuItem);
		subMenu = new JMenu("Simulator");
		menu.add(subMenu);
		menuItem = new JMenuItem("Delta time");
		menuItem.addActionListener(wl);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Graphics Refresh time");
		menuItem.addActionListener(wl);
		subMenu.add(menuItem);
                
        menu = new JMenu("Energy Plot");
		mb.add(menu);
		menuItem = new JMenuItem("On");
		menuItem.addActionListener(ep);
		menu.add(menuItem);
		menuItem = new JMenuItem("Off");
		menuItem.addActionListener(ep);
		menu.add(menuItem);
		menuItem = new JMenuItem("Clean");
		menuItem.addActionListener(ep);
		menu.add(menuItem);
		return mb;          
	}   
}
