import javax.swing.*;
import java.awt.Cursor;
import javax.swing.JSplitPane;
import java.awt.*;
import javax.swing.JApplet;
import java.util.*;

public class PhysicsLabApplet extends JApplet {
	public void init() {
		double refreshTime;
		double deltaTime;
		float viscosity;
		float gravity;
		int sideNum;
		int ballNum;
		int i=0;
		int flag=0;
		
		if(getParameter("sideNum") == null){
			System.out.println("sideNum not found"); 
			sideNum = 1;
			flag=1;
		}
		else sideNum =  Integer.parseInt(getParameter("sideNum"));
		
		if(getParameter("ballNum") == null){
			System.out.println("ballNum not found");
			ballNum = 1;
			flag=1;
		}
		else ballNum =  Integer.parseInt(getParameter("ballNum"));
		
		String stringAux = new String();
		String totalWall = new String();
			for(i=1; i<=sideNum;i++){
				stringAux = "wall."+i;
				if(getParameter(stringAux) == null) flag=1;
				if(i==1) totalWall = totalWall + getParameter(stringAux);
				else if (i==sideNum) totalWall = totalWall +";"+ getParameter(stringAux);
				else totalWall = totalWall +";"+ getParameter(stringAux);
			}
		
		String totalBall = new String();
			for(i=1; i<=ballNum;i++){
				stringAux = "ball."+i;
				if(getParameter(stringAux) == null) flag=1;
				if(i==1) totalBall = totalBall + getParameter(stringAux);
				else if (i==ballNum) totalBall = totalBall +";"+ getParameter(stringAux);
				else totalBall = totalBall +";"+ getParameter(stringAux);
			}
			if(flag == 1){
				sideNum = 1;
				ballNum = 1;
				totalWall="1.2;0.2;SIDEWAYS;2.8";
				totalBall = "250;0.2;1.5;0.6;10;6;red";
			}

			if(getParameter("refreshTime") == null) refreshTime = (float)0.03;
			else refreshTime = Double.valueOf(getParameter("refreshTime")).doubleValue();
			if(getParameter("deltaTime") == null) deltaTime = (float)0.001;
			else deltaTime = Double.valueOf(getParameter("deltaTime")).doubleValue();
			if (getParameter("viscosity") == null) viscosity = (float)0;
			else viscosity = Float.valueOf(getParameter("viscosity")).floatValue();
			if (getParameter("gravity") == null) gravity = (float)-9.8;
			else gravity = Float.valueOf(getParameter("gravity")).floatValue();
			MyWorld world = new MyWorld(refreshTime , deltaTime, viscosity, gravity);
			setSize(MyWorld.WIDTH, MyWorld.HEIGHT + 50);
			PhysicsLabPanel labPanel = new PhysicsLabPanel(world);
			add(labPanel); // it is equivalent to getContentPane().add(...);
			GraphsPanel graphPanel = new GraphsPanel();
			graphPanel.setAlignmentY(LEFT_ALIGNMENT);
			JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
			labPanel, graphPanel);
			labPanel.setMinimumSize(new Dimension(700, 500));
			graphPanel.setMinimumSize(new Dimension(500, 500));
			splitPane.setDividerLocation(this.getWidth());
			Container contentPane = getContentPane();
			contentPane.add(splitPane);
			if(getParameter("plotWindowTime") == null) graphPanel.setMaxTime(30);
			else graphPanel.setMaxTime(Double.valueOf(getParameter("plotWindowTime"))
					.doubleValue());
			world.setPanel(labPanel); // to repaint view when model changes
			world.setPanelGraphs(graphPanel);
			ElementMenuListener cListener = new ElementMenuListener(world, totalWall, sideNum, totalBall, ballNum);
			WorldControlMenuListener wcListener = new WorldControlMenuListener(
					world,/* graphPanel, */labPanel,/* splitPane, */contentPane/*, this*/);
			EnergyPlotMenuListener epListener = new EnergyPlotMenuListener(world,
					graphPanel, labPanel, splitPane, contentPane, this);
			RightClickMenuListener rc = new RightClickMenuListener(world);
			world.setBRC(rc);
			JMenuBar menuBar = createLabMenuBar(cListener, wcListener, epListener);
			menuBar.add(world.getBRCitem());
			setJMenuBar(menuBar);
		
		setVisible(true);
	}

	public JMenuBar createLabMenuBar(ElementMenuListener cl,
			WorldControlMenuListener wl, EnergyPlotMenuListener ep) {
		JMenuBar mb = new JMenuBar();

		JMenu menu = new JMenu("Element");
		mb.add(menu);

		JMenuItem menuItem = new JMenuItem("New Scenario");
		menu.add(menuItem);
		menuItem.addActionListener(cl);

		JMenu subMenu = new JMenu("Insert");
		menu.add(subMenu);

		menuItem = new JMenuItem("Ball");
		menuItem.addActionListener(cl);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Wall Sideways");
		menuItem.addActionListener(cl);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Wall Straight");
		menuItem.addActionListener(cl);
		subMenu.add(menuItem);

		menuItem = new JMenuItem("Scenario");
		menuItem.addActionListener(cl);
		subMenu.add(menuItem);

		menuItem = new JMenuItem("Delete");
		menuItem.addActionListener(cl);
		menu.add(menuItem);

		menu = new JMenu("MyWorld");
		mb.add(menu);
		menuItem = new JMenuItem("Start");
		menuItem.addActionListener(wl);
		menu.add(menuItem);
		menuItem = new JMenuItem("Stop");
		menuItem.addActionListener(wl);
		menu.add(menuItem);
		menuItem = new JMenuItem("Gravity");
		menuItem.addActionListener(wl);
		menu.add(menuItem);
		menuItem = new JMenuItem("Viscosity");
		menuItem.addActionListener(wl);
		menu.add(menuItem);
		subMenu = new JMenu("Simulator");
		menu.add(subMenu);
		menuItem = new JMenuItem("Delta time");
		menuItem.addActionListener(wl);
		subMenu.add(menuItem);
		menuItem = new JMenuItem("Graphics Refresh time");
		menuItem.addActionListener(wl);
		subMenu.add(menuItem);

		menu = new JMenu("Energy Plot");
		mb.add(menu);
		menuItem = new JMenuItem("On");
		menuItem.addActionListener(ep);
		menu.add(menuItem);
		menuItem = new JMenuItem("Off");
		menuItem.addActionListener(ep);
		menu.add(menuItem);
		menuItem = new JMenuItem("Clean");
		menuItem.addActionListener(ep);
		menu.add(menuItem);
		return mb;
	}
}
