public abstract class PhysicsElement {
	private final int myId; 

	protected PhysicsElement( int id){
		myId = id;
	}
	protected int getId() {
		return myId;
	}
	public abstract Vector2D getPosition();
	public abstract float getMass();
	public abstract float getRadius();
	public abstract Vector2D getSpeed();
	public abstract boolean collide(PhysicsElement pe);
	public abstract void computeNextState(double delta_t, MyWorld w);
	public abstract void updateState();
	public abstract String getState();
        public abstract boolean getOrientation();
	public abstract Vector2D getVectorBetweenCenters(PhysicsElement pe);
        public abstract float getEC();
	public abstract float getEP();
}
