import javax.swing.Timer;import java.awt.event.ActionListener;import java.awt.event.ActionEvent;
import java.awt.Graphics2D;
import java.util.*;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.BasicStroke;
import java.awt.geom.Line2D;
import java.awt.*;
import javax.swing.*;

import java.applet.AudioClip;
import java.net.URL;
import java.io.*;
import javax.sound.sampled.*;

/**
 *Class MyWorld represent the simulated world.
 * Contains all the elements of the system and the methods that
 * makes changes in the virtual world.
*/

public class MyWorld implements ActionListener {
	public int grap=0;
	public static final double DEAFAUL_REFRESH = 0.003;  // 30 [ms]
	public static final double DEFAUL_DELTA = 0.0001;    // 1 [ms]
	public static int WIDTH = 1100;  // in pixels
	public static int HEIGHT = 500; // in pixels
	public static int X_ORIGEN = (int)(WIDTH*0.1); // MyWorld space origin (x,y) will be on
	public static int Y_ORIGEN = (int)(HEIGHT*0.9); // (X_ORIGEN,Y_ORIGEN) of the panel space.
	public static AffineTransform SPACE_TRANSFORM;  // transforms (x,y) in (X,Y) of panel.
	public static AffineTransform SPACE_INVERSE_TRANSFORM; // transforms (X,Y) in (x,y) of my world.
	public static Line2D.Double SCALE_LINE;  // 1 [m] line
	
	public static AudioClip clipBall;
	public static AudioClip clipWall;
	//public static AePlayWave clipWall = new AePlayWave("./soundWall.wav");
	//public static AePlayWave clipBall = new AePlayWave("./soundBall.wav");
	
	private static double AXES_SCALE = 100.0;  // 1 [m] equals 100 [pixels]

	static {
		SPACE_TRANSFORM = AffineTransform.getTranslateInstance(X_ORIGEN, Y_ORIGEN);
		SPACE_TRANSFORM.scale(AXES_SCALE,-AXES_SCALE);  // it also inverts direction of y-coordinate 
		try {
			SPACE_INVERSE_TRANSFORM = SPACE_TRANSFORM.createInverse();
		}catch (NoninvertibleTransformException e){ 
			System.exit(0);
		}
		SCALE_LINE = new Line2D.Double(300,15, 300+AXES_SCALE,15);  // 1[m] line.
	

	
	}
	private double t;              // Simulation time
	private Timer pase;            // Clock to refresh the simulation's view. 
	private double delta_t;        // in seconds
	private double refreshPeriod;  // in seconds
        private boolean goingToDelete;
        private float ecTotal;
	private float epTotal;

	private Vector2D g;
	private float viscosity;
	private PhysicsLabPanel labPanel;
	private GraphsPanel graphsPanel;
	private Vector<PhysicsElement> elements;
        private BallRightClick brc;
        private boolean cursorState;
 /**
 * Constructor of the class. Sets all the parameters at 0 or a lower value to run.
 * @throws IOException 
 * @throws UnsupportedAudioFileException 
 * @throws LineUnavailableException 
 */


	public MyWorld(double rp, double dt, float v, float grav){
		t = 0;
		refreshPeriod = rp;      // initial value 40 [ms]
		delta_t = dt;          // initial value 1 [ms]
		pase = new Timer((int)(refreshPeriod*1000), this);
		g = new Vector2D(0,grav);  // start with no gravity
		viscosity = v;        // no friction
		elements = new Vector<PhysicsElement>();
		labPanel = null;
                cursorState = false;
                ecTotal=0;
		epTotal=0;
		try{
            URL sound = this.getClass().getClassLoader().getResource("soundBall.wav");
            clipBall = java.applet.Applet.newAudioClip(sound);
            
            URL sound2 = this.getClass().getClassLoader().getResource("soundWall.wav");
            clipWall = java.applet.Applet.newAudioClip(sound2);
            
		}catch(Exception e){System.out.println("Sounds not found"); System.exit(0);}
	}
/**
	 *Allows to assign the labPanel atribute of the class to the main panel of
	 * the simulation.
	 * @param p 	The Physics Lab Panel that is setted in the labPanel atribute.
	 */
	public void setPanel (PhysicsLabPanel p) {
		labPanel = p;
	}
/**
	 *Allows to assign the graphsPanel atribute of the class to a graphs panel in use
	 * @param gp 	The Graphs Panel input to set in graphsPanel atribute
	 */
	public void setPanelGraphs (GraphsPanel gp) {
		graphsPanel = gp;
	}
/**
	 *Sets the atribute goingToDelete as true, flag that represent that an element will be
	 *chosen to be deleted.
	 */
        public void Delete () {
            goingToDelete = true;
        }
/**
	 *Sets ad false the goingToDelete falg. Represents that an element was deleted or the user
	 *clicks on the air probably because regreted.
	 */
        public void Deleted (){
            goingToDelete = false;
        }
/**
	 *Reviews the goingToDelete flag.
	 *@return If the user is deleting an element.
	 */
        public boolean getDelete (){
            return (goingToDelete);
        }
/**
	 *Les to ask the actual time of the virtual simulation.
	 *@return The actual time.
	 */
	public float getTime (){
            return (float)t;
        }
	
/**
	 *Sets the cursor as a selector hand image and sets the cursorState flag as true
	 * representing that it is not the default cursor.
	 */
        public void CursorHand (){
            labPanel.setCursor(Cursor.getPredefinedCursor
               (Cursor.HAND_CURSOR));
            cursorState = true;
        }
/**
	 *Sets the cursor as a west resize image and sets the cursorState flag as true
	 * representing that it is not the default cursor.
	 */
        public void CursorLeft (){
            labPanel.setCursor(Cursor.getPredefinedCursor
               (Cursor.W_RESIZE_CURSOR));
            cursorState = true;
        }
/**
	 *Sets the cursor as an east resize image and sets the cursorState flag as true
	 * representing that it is not the default cursor.
	 */
        public void CursorRight (){
            labPanel.setCursor(Cursor.getPredefinedCursor
               (Cursor.E_RESIZE_CURSOR));
            cursorState = true;
        }
/**
	 *Sets the cursor as a down resize image and sets the cursorState flag as true
	 * representing that it is not the default cursor.
	 */
        public void CursorDown (){
            labPanel.setCursor(Cursor.getPredefinedCursor
               (Cursor.S_RESIZE_CURSOR));
            cursorState = true;
        }
/**
	 *Sets the cursor as an up resize image and sets the cursorState flag as true
	 * representing that it is not the default cursor.
	 */
        public void CursorUp (){
            labPanel.setCursor(Cursor.getPredefinedCursor
               (Cursor.N_RESIZE_CURSOR));
            cursorState = true;
        }
/**
	 *Sets the cursor as a hand to drag image and sets the cursorState flag as true
	 * representing that it is not the default cursor.
	 */
        public void CursorDrag (){
            labPanel.setCursor(Cursor.getPredefinedCursor
               (Cursor.MOVE_CURSOR));
            cursorState = true;
        }
/**
	 *Sets the cursor as the default cursor and sets the cursorState flag as false
	 * representing that the cursor is now the default one.
	 */
        public void CursorDefault (){
            labPanel.setCursor(Cursor.getDefaultCursor());
            cursorState = false;
        }
/**
	 *Lets to ask for the actual state of the cursorState flag.
	 *@return false just if the cursor is the default cursor, true in all the other cases.
	 */
        public boolean getCursorState(){
            return cursorState;
        }
/**
	 *Excecute the method color() of labPanel that lets the user to select a color.
	 *@return The color that the user chose.
	 */
        public Color Chooser(){
            return labPanel.color();
                    
        }
/**
	 *Ask for the brc atribute, an object of the BallRightClick class. Its contains the 
	 * JMenu that is showed when the user press the right click above a ball.
	 *@return The brc atribute.
	 */
        public BallRightClick getBRC()
        {
            return brc;
        }
/**
	 *Ask for the menu item of the brc atribute. Its contains the 
	 * the items of the JMenu that is showed when the user press the right click above a ball.
	 * Used to be added to the main JMenuBar.
	 *@return The brc items of the right click JMenu.
	 */
        public JMenu getBRCitem()
        {
            return brc.getItem();
        }
/**
	 *Sets the brc atribute, an object of the BallRightClick class. Its contains the 
	 * jpanel that is showed when the user press the right click above a ball.
	 * @param r The right Menu Listener for this JMenu.
	 */
        public void setBRC(RightClickMenuListener r)
        {
            brc = new BallRightClick(this, r);
        }
/**
	 *Sets the time of every step time on the simulation.
	 * @param delta The value of the time new step time [s].
	 */
	public void setDelta_t(double delta) {
		delta_t = delta;
	}
/**
	 *Sets the period which the windows elements are refreshed.
	 * @param rp The value of the new period [s].
	 */
	public void setRefreshPeriod (double rp) {
		refreshPeriod = rp;
		pase.setDelay((int)(refreshPeriod*1000)); // convert from [s] to [ms]
	}
/**
	 *Sets the gravity of the simulated world.
	 * @param gravity Vector that represent the gravity force [N].
	 */
	public void setGravity (Vector2D gravity) {
		g = gravity;
	}
/**
	 *Gets the gravity of the simulated world.
	 * @return Gravity Vector that represent the gravity force [N].
	 */
	public Vector2D getGravity(){
		return g;
	}
/**
	 *Sets the viscosity of the simulated world.
	 * @param v Viscosity value [Kg/(s m)].
	 */
	public void setViscosity(float v){
		viscosity = v;
	}
/**
	 *Gets the viscosity of the simulated world.
	 * @return Viscosity value [Kg/(s m)].
	 */
	public float getViscosity(){
		return viscosity;
	}
/**
	 *Refresh the window on the excecuted moment.
	 */
        public void refresh(){
		labPanel.repaint();
	}
/**
	 *Add an element to the simulated world. Then, refresh the window.
	 *@param e Element to add, an object of a subclass of PhysicsElement.
	*/
	public void addElement(PhysicsElement e) {
		elements.add(e);
		if (labPanel!=null)
			labPanel.repaint();
	}
/**
	 *Remove an element of the simulated world. Then, refresh the window.
	 *@param e Element to remove, an object of a subclass of PhysicsElement.
	*/
        public void removeElement(PhysicsElement e) {
		elements.remove(e);
		if (labPanel!=null)
			labPanel.repaint();
	}
/**
	 *Remove all elements of the simulated world.Then, refresh the window.
	 *  Used like a reset of the program.
	*/
        public void removeElements() {
            elements = new Vector<PhysicsElement>();
	}
/**
	 *Start the simulation process.
	*/
	public void start() {
		if(pase.isRunning()) return;
		labPanel.desableMouseListener();
		pase.start();      
	}
/**
	 *Stop the simulation process.
	*/
	public void stop(){
		pase.stop();
		labPanel.enableMouseListener();
	}
/**
	 *Every step time re-calculate makes the elements to get his next states.
	 * Then, makes the element jump to this state, gives the values of the energys
	 * to the graphs panel and refresh the window.
	 *@param event Event produced when a step time is passed.
	*/
	public void actionPerformed (ActionEvent event) {  // simulate time passing
		double nextStop=t+refreshPeriod;
                ecTotal = 0;
		epTotal = 0;
		while (t<nextStop) {
			for (PhysicsElement e: elements)   // for each element
				e.computeNextState(delta_t, this);  // compute next state
			for (PhysicsElement e: elements)    // for all elements
				e.updateState();                // update its state
			for (PhysicsElement e: elements){    // for all elements
				ecTotal = ecTotal + e.getEC();
				epTotal = epTotal + e.getEP();
			} 
			if(grap!=0) graphsPanel.addSeries(epTotal, ecTotal, ecTotal + epTotal, (t+delta_t));
			t+=delta_t;
		}
		labPanel.repaint();		
	}
/**
	 *Review if an element is collision with another.
	 *@param anchor Element to be reviewed.
	 *@return If there is a collision, the other element in the act. If there isn't, null.
	*/
	public PhysicsElement getNearCollision (PhysicsElement anchor) { // first implementation
		for (PhysicsElement e: elements) 
			if ((anchor != e) && anchor.collide(e))
				return e;
		return null;      
	}
/**
	 *Search for an specific element the closer element that may produce later a collision.
	 *@param anchor Wondering element.
	 *@return The nearest element of anchor.
	*/
	public PhysicsElement getNearestCollision (PhysicsElement anchor) {
		double minDistance=Double.MAX_VALUE;
		double distance;
		PhysicsElement nearest=null;
		for (PhysicsElement e: elements) {
			if (anchor!=e) {
				distance = anchor.getVectorBetweenCenters(e).module() - anchor.getRadius()-e.getRadius();
				if ((distance < minDistance) && anchor.collide(e)){
					
					if (e instanceof Wall)
						clipWall.play();					
					else
						clipBall.play();				
					minDistance = distance;
					nearest = e;
				}
			}
		}
		return nearest;      
	}
/**
	 *Paint all the components of the simulated world.
	*/
	public void paintComponent(Graphics2D g2d){
		g2d.drawString("ELO329 1er.Sem. 2012,   1 [m] = ", 85, 15);
		g2d.draw(SCALE_LINE);
		g2d.transform(SPACE_TRANSFORM);
		g2d.setStroke(new BasicStroke(0.02f));
		for (PhysicsElement e: elements)
			if (e instanceof Drawable)
				((Drawable)e).draw(g2d);
	}
/**
	 *Review for an specific position if there is an element.
	 *@return An element, if there is one. If there isn't, null.
	*/
	public Drawable find(double d, double f) {
		for (PhysicsElement e: elements)
			if (e instanceof Drawable){
				Drawable de = (Drawable) e;
				if (de.contains(d,f)) return de;
			}
		return null;
	}  

} 
