import java.awt.Color;
import javax.swing.JPanel;
import java.awt.event.*;
import java.awt.event.MouseAdapter;
import java.awt.geom.Point2D;


public class MouseListener extends MouseAdapter {
   private MyWorld world;
   private Drawable currentElement;
   private JPanel panel;
   private Vector2D pointStart;
   boolean selected;
   int draggin = 0;
   public MouseListener (MyWorld w, JPanel p){
      world = w;
      panel = p;
      selected = false;
      pointStart = new Vector2D(0,0);
   } 
   public void mouseMoved(MouseEvent e) {
      Point2D.Double p = new Point2D.Double(0,0);
      MyWorld.SPACE_INVERSE_TRANSFORM.transform(e.getPoint(),p);
      Drawable newElement = world.find(p.getX(), p.getY());
      Wall elm;
      if (newElement == currentElement && !world.getDelete()) 
      {
          if(currentElement instanceof GWall)
          {
              elm = (Wall) currentElement;
              if(elm.getOrientation())
              {
                if(p.distance(elm.getX(), p.getY()) >= (elm.getLength()-0.1))
                    world.CursorLeft();
                else if(p.distance(elm.getX(), p.getY()) <= 0.1)
                    world.CursorRight();
                else
                    world.CursorDrag();
              }
              else 
              {
                if(p.distance(p.getX(), elm.getY()) >= (elm.getLength()-0.1))
                    world.CursorDown();
                else if(p.distance(p.getX(), elm.getY()) <= 0.1)
                    world.CursorUp();
                else
                    world.CursorDrag();
              }
                  
          }
          else if (currentElement instanceof GBall && !world.getDelete()) world.CursorDrag();
          return;
      }
      if (currentElement != null) {
         currentElement.setReleased();
         currentElement = null;
         if(world.getCursorState() && !world.getDelete())
         world.CursorDefault();
      }
      if (newElement != null) { 
         currentElement = newElement;
         currentElement.setSelected();
         if(currentElement instanceof GWall && !world.getDelete())
          {
              elm = (Wall) currentElement;
              if(elm.getOrientation())
              {
                if(p.distance(elm.getX(), p.getY()) >= (elm.getLength()-0.1))
                    world.CursorLeft();
                else if(p.distance(elm.getX(), p.getY()) <= 0.1)
                    world.CursorRight();
                else
                    world.CursorDrag();
              }
              else
              {
                if(p.distance(p.getX(), elm.getY()) >= (elm.getLength()-0.1))
                    world.CursorDown();
                else if(p.distance(p.getX(), elm.getY()) <= 0.1)
                    world.CursorUp();
                else
                    world.CursorDrag();
              }
                  
          }
         else if (currentElement instanceof GBall && !world.getDelete()) world.CursorDrag();
      }
      panel.repaint();
   }
   public void mouseDragged(MouseEvent e) {
      Point2D.Double p = new Point2D.Double(0,0);
       Wall w;
      MyWorld.SPACE_INVERSE_TRANSFORM.transform(e.getPoint(),p);
      if (currentElement == null) return;
      if (currentElement instanceof GWall && (draggin == 0 || draggin == 1))
      {
        w = (Wall) currentElement;
        if(w.getOrientation())
        {
            if(!selected)
            {
            if(p.distance(w.getX(), p.getY()) >= (w.getLength()-0.1))
                {
                    pointStart = new Vector2D(w.getX(),w.getY());
                    selected = true;
        	    draggin = 1;
                }
            if(p.distance(w.getX(), p.getY()) <= 0.1)
                {
                    pointStart = new Vector2D(w.getX()+w.getLength(),w.getY());
                    selected = true;
        	    draggin = 1;
                }
            }
            if(selected)
            {
                if( (p.getX()-pointStart.getX())>0 )
                {
                    w.setLength((float)(p.getX()-pointStart.getX()));
                    world.CursorLeft();
                }
                else
                {
                    w.setLength((float)(pointStart.getX()- p.getX()));
                    w.setPosition(p.getX(), pointStart.getY());
                    world.CursorRight();
                }
                panel.repaint();
                return;
            }
        }
        else
        {
            if(!selected)
            {
                if(p.distance(p.getX(), w.getY()) >= (w.getLength()-0.1))
                {
                    selected = true;
                    pointStart = new Vector2D(w.getX(),w.getY());
        	    draggin = 1;
                }
                if(p.distance(p.getX(), w.getY()) <= 0.1)
                {
                    selected = true;
                    pointStart = new Vector2D(w.getX(),w.getY()+w.getLength());
        	    draggin = 1;
                }
            }
            if(selected)
            {
                if( (p.getY()-pointStart.getY())>0 )
                {
                    w.setLength((float)(p.getY()-pointStart.getY()));
                    world.CursorDown();
                }
                else
                {
                    w.setLength((float)(pointStart.getY()- p.getY()));
                    w.setPosition(pointStart.getX(), p.getY());
                    world.CursorUp();
                }
                panel.repaint();
                return;
            }
            
        }
                
      }
      

      if (currentElement instanceof GWall && (draggin == 0 || draggin == 2))
      { 
	draggin = 2;
        w = (Wall) currentElement;
        if(w.getOrientation())
            currentElement.dragTo(p.getX()-.4, p.getY());
        else 
            currentElement.dragTo(p.getX(), p.getY()-.4);
      }
      else if (draggin == 0 || draggin == 2)
	{ 
	  draggin = 2;
          currentElement.dragTo(p.getX(), p.getY());
	}
      world.CursorDrag();

      panel.repaint();
   }
   public void mouseReleased(MouseEvent e) {
      if (currentElement != null) 
	{
         currentElement.setReleased(); 
	 draggin = 0;
	}
      selected = false;
      if(!world.getDelete())
      world.CursorDefault();
      if(e.isPopupTrigger() && currentElement instanceof GBall){
              BallRightClick menu = world.getBRC();
              menu.show(e.getComponent(), e.getX(), e.getY(), currentElement);
          }
   }
   
   public void mouseClicked(MouseEvent e) {
       if(world.getDelete() && e.getModifiers() == InputEvent.BUTTON1_MASK)
       {
            if (currentElement != null){
                world.removeElement((PhysicsElement)currentElement);
                panel.repaint();
            }
            world.Deleted();
            world.CursorDefault();
        }
   }
   
   public void mousePressed(MouseEvent e){
        if(e.isPopupTrigger() && currentElement instanceof GBall && !world.getDelete()){
              GBall b = (GBall) currentElement;
              //b.setColor(world.Chooser());
              BallRightClick menu = world.getBRC();
              menu.show(e.getComponent(), e.getX(), e.getY(), currentElement);
          }
   }
 
}
