import javax.swing.*; 
import javax.swing.JApplet;
import org.jfree.data.xy.*;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;

/**
 * class that allows us to create a panel that contains graphs.
 * @author Claudio Price
 */
public class GraphsPanel extends JPanel{

   private JFreeChart [] chart;
   double maxtime = 30;
   private XYSeriesCollection[] datasets;
   NumberAxis [] rangeAxisX;
   NumberAxis [] rangeAxisY;
/**
 * Constructor. Creates the panel that contains all three graphics.
 */
   
   public GraphsPanel(){
    XYSeries series;
    datasets = new XYSeriesCollection[3];
    chart = new JFreeChart[3];
    rangeAxisX = new NumberAxis[3];
    rangeAxisY = new NumberAxis[3];
    rangeAxisX[0] = new NumberAxis("t [s]");
    rangeAxisX[0].setLowerBound(0);
    rangeAxisX[0].setUpperBound(maxtime);
    rangeAxisY[0] = new NumberAxis("Potencial [J]");
    rangeAxisX[1] = new NumberAxis("t [s]");
    rangeAxisX[1].setLowerBound(0);
    rangeAxisX[1].setUpperBound(maxtime);
    rangeAxisY[1] = new NumberAxis("Cinetica [J]");
    rangeAxisX[2] = new NumberAxis("t [s]");
    rangeAxisX[2].setLowerBound(0);
    rangeAxisX[2].setUpperBound(maxtime);
    rangeAxisY[2] = new NumberAxis("Potencial + Cinetica [J]");
    
    this.setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
    
    for (int i = 0; i < 3; i++) {
        series = new XYSeries("",false);
        datasets[i] = new XYSeriesCollection(series);
        rangeAxisX[i].setAutoRangeIncludesZero(false);
        rangeAxisY[i].setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(datasets[i], rangeAxisX[i], rangeAxisY[i], new StandardXYItemRenderer());
        chart[i] = new JFreeChart("", plot);
        chart[i].removeLegend();
        ChartPanel chartPanel = new ChartPanel(chart[i]);
        add(chartPanel);
    }

    chart[0].setTitle("Energia Potencial [J]");
    chart[1].setTitle("Energia Cinetica [J]");
    chart[2].setTitle("Energia Total [J]");
   }
 
 /**
 * Method. Updates the graphs and resizes the x axis when is needed.
 * @param energiap 	Potential Energy to be plotted.
 * @param energiac 	Cinetic energy to be plotted.
 * @param energiat 	Total energy of the system to be plotted.
 * @param t 	Time associated to the position vector.
 */
   public void addSeries(float energiap, float energiac, float energiat, double t){
      if (datasets[0].getSeries(0).getItemCount() > 0 && ((datasets[0].getSeries(0).getX(datasets[0].getSeries(0).getItemCount()-1).doubleValue() - datasets[0].getSeries(0).getX(0).doubleValue()) > maxtime)){
        for (int i = 0; i < 3; i++) {
            datasets[i].getSeries(0).remove(0);
        }
        for (int i = 0; i < 3; i++) {
            rangeAxisX[i].setLowerBound(t-maxtime);
            rangeAxisX[i].setUpperBound(t);
        }
      }
      datasets[0].getSeries(0).add(t, energiap);
      datasets[1].getSeries(0).add(t, energiac);
      datasets[2].getSeries(0).add(t, energiat);
   }
 
   /**
 * Method.  Updates the graphs when there is a newly selected object.
 * @param t Time in which the time is selected
 */
   public void newSelected(double t){
       for (int i = 0; i < 3; i++) {
            rangeAxisX[i].setLowerBound(t);
            rangeAxisX[i].setUpperBound(t + maxtime);
       }
   }

   
   /**
 * Method. The graphs are reseted to zero.
 * @param t Time in which the graphs are reseted.
 */
   public void reset(double t){
       for (int i = 0; i < 3; i++) {
            datasets[i].removeSeries(0);
            datasets[i].addSeries(new XYSeries("",false));
       }
       for (int i = 0; i < 3; i++) {
            rangeAxisX[i].setLowerBound(t);
            rangeAxisX[i].setUpperBound(t+maxtime);
       }
   }
   
   /**
 * Method.  Sets the maximum time displayed in the graphs and resizes the axis.
 * @param maxt New maximum time 	
 */
   public void setMaxTime(double maxt){
       for (int i = 0; i < 3; i++) {
            rangeAxisX[i].setUpperBound(rangeAxisX[i].getLowerBound() + maxt);
       }
       maxtime = maxt;
   }  
}
