import java.awt.*;
import java.awt.geom.*;
class GWall extends Wall implements Drawable {
	private static final double WIDTH=0.1; 
	private Color color = Color.GREEN;
	private Rectangle2D.Double shape = null;
	public GWall (Vector2D initPos, int orientation, float length, MyWorld world) {
		super(initPos, orientation, length, world);
		switch (orientation){
		case SIDEWAYS: 
			shape = new Rectangle2D.Double(initPos.getX(),initPos.getY(),length, WIDTH);
			break;
		case STRAIGHT: 
			shape =  new Rectangle2D.Double(initPos.getX(),initPos.getY(), WIDTH, length);
			break;
		}
	}
	public void draw (Graphics2D g){
		switch (orientation){
		case SIDEWAYS: 
			shape.setFrame(anchor.getX(), anchor.getY(), length, WIDTH);
			break;
		case STRAIGHT: 
			shape.setFrame(anchor.getX(), anchor.getY(), WIDTH, length);
			break;
		}
		g.setColor(color);
		g.fill(shape);
	}
	public boolean contains (double x, double y){
		return shape.contains(x,y);
	}
	public void dragTo(double x, double y){
		setPosition(x,y);
	}
	public void setSelected(){
		color = Color.RED;
	}
	public void setReleased() {
		color = Color.GREEN;
	}
}