import java.awt.*;
import java.awt.geom.*;
class GBall extends Ball implements Drawable {
   private Color color = Color.BLUE;
   private Color base = Color.BLUE;
   private Ellipse2D.Float shape = null;
   public GBall (float mass, float r, Vector2D position, Vector2D speed, MyWorld world){
      super(mass, r, position, speed, world);
      shape = new Ellipse2D.Float((float)getX()-r, (float)getY()-r, 2*r, 2*r);
   }
   public GBall (float mass, float r, Vector2D position, Vector2D speed, MyWorld world, Color c){
      super(mass, r, position, speed, world);
      shape = new Ellipse2D.Float((float)getX()-r, (float)getY()-r, 2*r, 2*r);
      base = new Color (c.getRGB());
      color = new Color (base.getRGB());
   }
   public void draw (Graphics2D g){
      shape.setFrame((float)getX()-radius, (float)getY()-radius, 2*radius, 2*radius);
      g.setColor(color);
      g.fill(shape);
   }
   public boolean contains (double x, double y){
      return shape.contains(x,y);
   }
   public void dragTo(double x, double y){
      setPosition(x,y);
   }
   public void setSelected (){
      color = Color.RED;
   }
   public void setReleased() {
      color = new Color (base.getRGB());
   }
   public void setColor (Color c){
      base = new Color(c.getRGB());
      color = new Color (base.getRGB());
   }
}