public class Ball extends PhysicsElement  {
	private static int id=0;  // Ball identification number
	protected float mass;
	protected float radius;
	private double crossSection; // to compute air friction 	
	private Vector2D pos_t;     // current position at time t
	private Vector2D pos_tPlusDelta;  // next position at t+delta
	private Vector2D speed_t;   // speed at time t
	private Vector2D speed_tPlusDelta;   // speed at t+delta
	private Vector2D a_t;    // acceleration at time t
	private Vector2D a_tMinusDelta;  // acceleration at t-delta;
        private float eCinetica;
	private float ePotencial;
        private MyWorld world;

	private Ball(){   // nobody can create a block without state
		super(id++);
		mass=0;
		radius=0;
	}
	public Ball(float mass, float r, Vector2D position, Vector2D speed, MyWorld world){
		super(id++);
		this.mass = mass;
                this.world = world;
		radius = r;
		pos_t = position;
		speed_t = speed;
		a_t = new Vector2D();
		a_tMinusDelta = getNetForce(world.getGravity(), world.getViscosity()).times(1/mass);
		crossSection = 6*Math.PI*r;
                eCinetica = mass*(float)speed_t.moduleSquared()/2;
		ePotencial = Math.abs(mass*(float)world.getGravity().module()*(float)position.getY());
		world.addElement(this);
	}
	public float getMass() {
		return mass;
	}
	public float getRadius() {
		return radius;
	}
        public boolean getOrientation() {
		return false;
	}
        public void setRadius(float r) {
		radius = r;
	}
        public void setMass(float m){
            mass = m;
        }
	public Vector2D getPosition() {
		return pos_t;
	}
	public Vector2D getSpeed() {
		return speed_t;
	}
	public double getX() {
		return pos_t.getX();
	}
	public double getY() {
		return pos_t.getY();
	}
	public void setPosition(double x, double y){
		pos_t.set(x,y);
	}
	public void setCrossSection(double cs) {
		crossSection = cs;
	}
	private Vector2D getNetForce(Vector2D g, float viscosity ) {
		Vector2D force;
		force = g.times(mass);
		force = force.minus(speed_t.times(viscosity*crossSection)); 
		return(force);    
	} 
	public void computeNextState(double delta_t, Vector2D g, float viscosity) {
		a_t = getNetForce(g, viscosity).times(1/mass);
		speed_tPlusDelta = speed_t.plus(a_t.times(3).minus(a_tMinusDelta).times(delta_t/2));
		pos_tPlusDelta = pos_t.plus(speed_t.times(delta_t)).plus(a_t.times(4).minus(a_tMinusDelta).times(delta_t*delta_t/6));
	}
	public void computeNextState(double delta_t, MyWorld w) {
		Vector2D g=w.getGravity();
		float viscosity=w.getViscosity();
		Vector2D speed;
		PhysicsElement pe;
		if ((pe=w.getNearestCollision(this))!= null){ /* elastic collision */
			Vector2D v = pe.getVectorBetweenCenters(this); 
		/* ¿why do we ask pe to obtain this vector and we do not calculate it here? */ 
			Vector2D thisSp = speed_t.getProjectionOn(v);  /* this speed projection: projection of speed_t on u */
			speed = pe.getSpeed().getProjectionOn(v).minus(thisSp);
			float peMass = pe.getMass();
			speed = speed.times(2*peMass/(mass+peMass));
			speed = speed_t.plus(speed);
			a_tMinusDelta = getNetForce(g, viscosity).times(1/mass);
		} else 
			speed = speed_t;

		a_t = getNetForce(g, viscosity).times(1/mass);
		speed_tPlusDelta = speed.plus(a_t.times(3).minus(a_tMinusDelta).times(delta_t/2));
		pos_tPlusDelta = pos_t.plus(speed.times(delta_t));
		pos_tPlusDelta = pos_tPlusDelta.plus(a_t.times(4).minus(a_tMinusDelta).times(delta_t*delta_t/6));
	}
	public void updateState(){
		pos_t = pos_tPlusDelta;
		speed_t = speed_tPlusDelta;
		a_tMinusDelta = a_t;
                eCinetica = mass*(float)speed_t.moduleSquared()/2;
		ePotencial = Math.abs(mass*(float)world.getGravity().module()*(float)pos_t.getY());
	}
	public boolean collide(PhysicsElement pe){
		if (pe==this || pe==null) return false;
		Vector2D separation = getVectorBetweenCenters(pe);
		boolean tooClose = separation.module() < (pe.getRadius()+radius);
		if (!tooClose) return false;
		boolean approaching = pe.getSpeed().minus(speed_t).dotProduct(separation) < 0;
		return (approaching);
	}
	public Vector2D getVectorBetweenCenters(PhysicsElement pe) {
		if (pe instanceof Wall)
			return pe.getVectorBetweenCenters(this);
		return pe.getPosition().minus(getPosition());
	}
	public String getState() {
		return "BAll "+getPosition()+" \n";
	}
        public float getEC(){
            return eCinetica;
        }
	public float getEP(){
            return ePotencial;
        }
}
