import java.awt.event.*;
import javax.swing.JOptionPane;
import javax.swing.JMenuItem;

public class WorldControlMenuListener implements ActionListener {
   private MyWorld world;

   //A pointer to the JMenu Item that holds the Insert Action
   private JMenuItem insertItem;

   public WorldControlMenuListener (MyWorld w){
      world = w;
   }

   //A method to give the JMenuItem to this Object
   public void setInsertMenuItemPointer(JMenuItem i){
       insertItem = i;
   }
   public void actionPerformed(ActionEvent e) {
      JMenuItem menuItem = (JMenuItem)(e.getSource());
      String text = menuItem.getText();

      //Prueba 1, intentar desabilitar Insert Menu item desde aca (HECHO)

      if (text.equals("Start"))  {
          world.start();
          insertItem.setEnabled(false);
      }

      //I should make it enabled when the simulation has stoped
      if (text.equals("Stop"))  {
          world.stop();
          insertItem.setEnabled(true);
      }
      if (text.equals("Gravity")) {
         String data = JOptionPane.showInputDialog("Enter Gravity [m/s^2]");
         world.setGravity(new Vector2D(0,Float.parseFloat(data)));
      }
      if (text.equals("Viscosity")) {
         String data = JOptionPane.showInputDialog("Enter Viscosity [kg/(sm)]");
         world.setViscosity(Float.parseFloat(data));
      }
      if (text.equals("Delta time")) {
         String data = JOptionPane.showInputDialog("Enter delta t [s]");
         world.setDelta_t(Float.parseFloat(data));
      }
      if (text.equals("Graphics Refresh time")) {
         String data = JOptionPane.showInputDialog("Enter refresh time [s]");
         world.setRefreshPeriod(Float.parseFloat(data));
      }

      //Se agrega accion para Resume
      if(text.equals("Resume")){
          world.resume();
          insertItem.setEnabled(false);
      }

      //TODO here i should  add the rubber action
   }
}