public class Vector2D implements Cloneable {
   private double x, y;  // we will use cartesian coordinates
   public Vector2D () {
      x = y = 0;
   }
   public Vector2D (double x, double y) {
      this.x = x;
      this.y = y;
   }
   public double getX(){
      return x;
   }
   public double getY(){
      return y;
   }
   public void set(double x, double y){ // to set a new position
      this.x=x;
      this.y=y;
   }
   public Vector2D plus(Vector2D v) {
      try {
         if (v==null) return (Vector2D) clone();
      } catch (CloneNotSupportedException e){
         return null;
      }
      return new Vector2D(x+v.x, y+v.y);
   }
   public Vector2D times(double scalar) {
      return new Vector2D(x*scalar, y*scalar);
   }
   public Vector2D minus(Vector2D v) {
      try {
         if (v==null) return (Vector2D) clone();
      } catch (CloneNotSupportedException e){
         return null;
      }
      return new Vector2D(x-v.x, y-v.y);
   }
   public double module() {
      return Math.sqrt(x*x+y*y);
   }
   public Vector2D unitary() {
      return times(1/module());
   }
   public static String getDescription() {
      return "(x,y)";
   }
   public String toString() {
      return x+","+y;
   }
}
   